/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.generator.reactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.tuple.Pair;
import owmii.lib.util.Data;
import owmii.lib.util.Energy;
import owmii.lib.util.Ticker;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.ITiles;
import owmii.powah.block.generator.GeneratorTile;
import owmii.powah.item.IItems;

public class ReactorTile
extends GeneratorTile {
    protected final FluidTank tank = new FluidTank(1000){

        public boolean isFluidValid(FluidStack stack) {
            return PowahAPI.REACTOR_COOLANTS.containsKey(stack.getFluid()) && super.isFluidValid(stack);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            ReactorTile.this.sync(5);
        }
    };
    private final LazyOptional<IFluidHandler> holder;
    private List<BlockPos> posList = new ArrayList<BlockPos>();
    private BlockPos corePos = BlockPos.field_177992_a;
    private boolean isCore;
    private boolean built;
    private final Ticker fuel = new Ticker(1000.0);
    private final Ticker carbon = Ticker.empty();
    private final Ticker redstone = Ticker.empty();
    private final Ticker solidCoolant = Ticker.empty();
    private int solidCoolantTemp;
    private final Ticker temp = new Ticker(1000.0);
    private int baseTemp;
    private int carbonTemp;
    private int redstoneTemp;

    public ReactorTile(int capacity, int transfer, int perTick) {
        super(ITiles.REACTOR, capacity, transfer, perTick);
        this.holder = LazyOptional.of(() -> this.tank);
        this.inv.add(4);
    }

    public ReactorTile() {
        this(0, 0, 0);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.posList = (List)Data.readPosList((CompoundNBT)compound, (String)"QueuedPos", new ArrayList());
        this.baseTemp = compound.func_74762_e("BaseTemp");
        this.carbonTemp = compound.func_74762_e("CarbonTemp");
        this.redstoneTemp = compound.func_74762_e("RedstoneTemp");
    }

    @Override
    public void readSync(CompoundNBT compound) {
        this.tank.readFromNBT(compound);
        this.corePos = Data.readPos((CompoundNBT)compound, (String)"CorePos");
        this.isCore = compound.func_74767_n("IsCore");
        this.built = compound.func_74767_n("Built");
        this.fuel.read(compound, "Fuel");
        this.carbon.read(compound, "Carbon");
        this.redstone.read(compound, "Redstone");
        this.solidCoolant.read(compound, "SolidCoolant");
        this.solidCoolantTemp = compound.func_74762_e("SolidCoolantTemp");
        this.temp.read(compound, "Temperature");
        super.readSync(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        Data.writePosList((CompoundNBT)compound, this.posList, (String)"QueuedPos");
        compound.func_74768_a("BaseTemp", this.baseTemp);
        compound.func_74768_a("CarbonTemp", this.carbonTemp);
        compound.func_74768_a("RedstoneTemp", this.redstoneTemp);
        return super.func_189515_b(compound);
    }

    @Override
    public CompoundNBT writeSync(CompoundNBT compound) {
        this.tank.writeToNBT(compound);
        Data.writePos((CompoundNBT)compound, (BlockPos)this.corePos, (String)"CorePos");
        compound.func_74757_a("IsCore", this.isCore);
        compound.func_74757_a("Built", this.built);
        this.fuel.write(compound, "Fuel");
        this.carbon.write(compound, "Carbon");
        this.redstone.write(compound, "Redstone");
        this.solidCoolant.write(compound, "SolidCoolant");
        compound.func_74768_a("SolidCoolantTemp", this.solidCoolantTemp);
        this.temp.write(compound, "Temperature");
        return super.writeSync(compound);
    }

    @Override
    protected boolean doTick() {
        return this.isCore;
    }

    @Override
    protected boolean postTicks() {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (!this.isCore) {
            return false;
        }
        boolean flag = false;
        int extracted = 0;
        if (this.built) {
            int carbon;
            ItemStack stack;
            boolean generating;
            for (Direction direction : Direction.values()) {
                if (!this.canExtract(direction)) continue;
                int amount = Math.min(this.getMaxExtract(), this.getEnergyStored());
                BlockPos pos = this.field_174879_c.func_177967_a(direction, direction.func_176740_k().func_176722_c() ? 2 : (direction.equals((Object)Direction.UP) ? 4 : 1));
                int received = Energy.receive((TileEntity)this.field_145850_b.func_175625_s(pos), (Direction)direction, (int)amount, (boolean)false);
                extracted += this.extractEnergy(received, false, direction);
            }
            boolean bl = generating = !this.internal.isFull() && !this.fuel.isEmpty();
            if (this.fuel.getTicks() <= 900.0 && (stack = this.inv.getStackInSlot(0)).func_77973_b() == IItems.URANINITE) {
                this.fuel.add(100.0);
                this.baseTemp = 700;
                stack.func_190918_g(1);
                flag = true;
            }
            if (this.fuel.isEmpty()) {
                this.baseTemp = 0;
            }
            if (this.carbon.isEmpty() && !(stack = this.inv.getStackInSlot(1)).func_190926_b() && (carbon = ForgeHooks.getBurnTime((ItemStack)stack)) > 0) {
                this.carbon.setAll((double)carbon);
                this.carbonTemp = 180;
                stack.func_190918_g(1);
                flag = true;
            }
            if (!this.carbon.isEmpty()) {
                if (generating) {
                    this.carbon.back();
                    if (this.carbon.isEmpty()) {
                        this.carbon.setMax(0.0);
                    }
                }
            } else {
                this.carbonTemp = 0;
            }
            if (this.redstone.isEmpty()) {
                stack = this.inv.getStackInSlot(2);
                if (stack.func_77973_b() == Items.field_151137_ax) {
                    this.redstone.setAll(18.0);
                } else if (stack.func_77973_b() == Items.field_221858_em) {
                    this.redstone.setAll(162.0);
                }
                this.redstoneTemp = 120;
                stack.func_190918_g(1);
                flag = true;
            }
            if (!this.redstone.isEmpty()) {
                if (generating && this.ticks % 40 == 0) {
                    this.redstone.back();
                    if (this.redstone.isEmpty()) {
                        this.redstone.setMax(0.0);
                    }
                    flag = true;
                }
            } else {
                this.redstoneTemp = 0;
            }
            if (this.solidCoolant.isEmpty() && !(stack = this.inv.getStackInSlot(3)).func_190926_b()) {
                Pair<Integer, Integer> coolant = PowahAPI.getReactorSolidCoolant((IItemProvider)stack.func_77973_b());
                int size = (Integer)coolant.getLeft();
                int temp = (Integer)coolant.getRight();
                if (size > 0 && temp < 2) {
                    this.solidCoolant.setAll((double)size);
                    this.solidCoolantTemp = temp;
                    stack.func_190918_g(1);
                    flag = true;
                }
            }
            if (!this.solidCoolant.isEmpty()) {
                if (!this.tank.isEmpty() && generating && this.ticks % 40 == 0) {
                    this.solidCoolant.back();
                    if (this.solidCoolant.isEmpty()) {
                        this.solidCoolant.setMax(0.0);
                    }
                    flag = true;
                }
            } else {
                this.solidCoolantTemp = 0;
            }
            double temp = Math.min((double)(this.baseTemp + this.carbonTemp + this.redstoneTemp), this.temp.getMax());
            if (!this.tank.isEmpty()) {
                int coldness = PowahAPI.getReactorCoolant(this.tank.getFluid().getFluid()) - 2;
                int i = Math.abs(coldness + this.solidCoolantTemp) + 1;
                temp /= (double)i;
                this.sync(5);
            }
            if (this.temp.getTicks() < temp) {
                this.temp.onward();
                flag = true;
            }
            if (this.ticks % (this.tank.isEmpty() ? 5 : (this.solidCoolant.isEmpty() ? 3 : 1)) == 0 && this.temp.getTicks() > temp) {
                this.temp.back();
                flag = true;
            }
        } else if (!this.build()) {
            return false;
        }
        if (flag && this.isContainerOpen) {
            this.sync(3);
        }
        return super.postTicks() || extracted > 0;
    }

    @Override
    protected void generate() {
        if (this.nextGen <= 0 && !this.fuel.isEmpty()) {
            double temp = this.temp.getTicks();
            this.fuel.back(this.calcConsumption());
            this.nextGen = this.nextGenCap = (int)this.calcProduction();
        }
    }

    public double calcProduction() {
        double d = this.carbon.isEmpty() ? 1.0 : 1.2;
        double d1 = this.redstone.isEmpty() ? 1.0 : 1.4;
        return (1.0 - this.calcConsumption()) * (this.fuel.getTicks() / 100.0) * (double)this.perTick * d * d1;
    }

    public double calcConsumption() {
        double d = this.redstone.isEmpty() ? 1.0 : 1.4;
        return this.temp.getTicks() / 1000.0 * 0.98 / 2.0 * d;
    }

    private boolean build() {
        if (this.field_145850_b == null) {
            return false;
        }
        if (!this.posList.isEmpty()) {
            boolean flag = true;
            for (BlockPos pos : this.posList) {
                if (this.field_145850_b.func_180495_p(pos).func_185904_a().func_76222_j()) continue;
                flag = false;
                break;
            }
            if (flag && this.ticks > 3 && this.ticks % 5 == 0) {
                Iterator<BlockPos> itr = this.posList.iterator();
                while (itr.hasNext()) {
                    BlockPos pos;
                    pos = itr.next();
                    this.field_145850_b.func_180501_a(pos, this.getBlock().func_176223_P(), 3);
                    TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
                    if (!(tileEntity instanceof ReactorTile)) continue;
                    ReactorTile part = (ReactorTile)tileEntity;
                    part.setCorePos(this.field_174879_c);
                    this.field_145850_b.func_217379_c(2001, pos, Block.func_196246_j((BlockState)this.func_195044_w()));
                    itr.remove();
                    return false;
                }
            }
        } else {
            for (BlockPos pos : this.getPosList()) {
                TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
                if (!(tileEntity instanceof ReactorTile)) continue;
                ReactorTile part = (ReactorTile)tileEntity;
                part.built = true;
                part.markDirtyAndSync();
            }
            this.built = true;
            this.markDirtyAndSync();
        }
        return true;
    }

    public void demolish() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.isCore) {
            List<BlockPos> list = this.getPosList();
            list.add(this.field_174879_c);
            for (int i = 0; i < list.size(); ++i) {
                BlockPos blockPos = list.get(i);
                if (!this.field_145850_b.func_180495_p(blockPos).func_177230_c().equals(this.getBlock())) continue;
                Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)new ItemStack((IItemProvider)this.getBlock()));
                this.field_145850_b.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
            }
            this.posList.forEach(pos -> Block.func_220059_a((BlockState)this.func_195044_w(), (World)this.field_145850_b, (BlockPos)this.field_174879_c, (TileEntity)this));
            while (this.fuel.getTicks() >= 100.0) {
                Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)new ItemStack((IItemProvider)IItems.URANINITE));
                this.fuel.back(100.0);
            }
            this.posList.clear();
            this.field_145850_b.func_180501_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P(), 3);
        } else {
            ReactorTile reactor;
            TileEntity tile = this.field_145850_b.func_175625_s(this.corePos);
            if (tile instanceof ReactorTile && (reactor = (ReactorTile)tile).func_174877_v().equals((Object)this.corePos)) {
                reactor.demolish();
            }
        }
    }

    @Override
    public int getChargingSlots() {
        return 0;
    }

    public boolean isNBTStorable() {
        return false;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public boolean isCore() {
        return this.isCore;
    }

    public void setCore(boolean core) {
        this.isCore = core;
        if (core) {
            this.posList.addAll(this.getPosList());
            Collections.shuffle(this.posList);
        }
    }

    public boolean isBuilt() {
        return this.built;
    }

    public Optional<ReactorTile> core() {
        ReactorTile reactor;
        if (this.field_145850_b == null || this.isCore()) {
            return Optional.empty();
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.corePos);
        if (tile instanceof ReactorTile && (reactor = (ReactorTile)tile).isCore()) {
            return Optional.of(reactor);
        }
        return Optional.empty();
    }

    public BlockPos getCorePos() {
        return this.corePos;
    }

    public void setCorePos(BlockPos corePos) {
        this.corePos = corePos;
    }

    public Ticker getFuel() {
        return this.fuel;
    }

    public Ticker getCarbon() {
        return this.carbon;
    }

    public Ticker getRedstone() {
        return this.redstone;
    }

    public Ticker getSolidCoolant() {
        return this.solidCoolant;
    }

    public int getSolidCoolantTemp() {
        return this.solidCoolantTemp;
    }

    public Ticker getTemp() {
        return this.temp;
    }

    @Override
    public boolean isExtractor() {
        return true;
    }

    @Override
    public boolean canExtractFromSides() {
        return false;
    }

    @Override
    public boolean canChargeItems() {
        return false;
    }

    public List<BlockPos> getPosList() {
        return BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(-1, 0, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 3, 1)).map(BlockPos::func_185334_h).filter(pos1 -> !pos1.equals((Object)this.field_174879_c)).collect(Collectors.toList());
    }

    @Override
    public boolean isEnergyPresent(@Nullable Direction side) {
        return side != null && (this.isCore || side.func_176740_k().func_176722_c() && this.field_174879_c.func_177972_a(side.func_176734_d()).equals((Object)this.corePos) || side.equals((Object)Direction.UP) && this.field_174879_c.func_177972_a(side.func_176734_d()).func_177982_a(0, -2, 0).equals((Object)this.corePos));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72314_b(1.0, 3.0, 1.0);
    }

    @Override
    public boolean canInsert(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() == IItems.URANINITE;
        }
        if (index == 1) {
            return ForgeHooks.getBurnTime((ItemStack)stack) > 0 && !stack.hasContainerItem();
        }
        if (index == 2) {
            return stack.func_77973_b() == Items.field_151137_ax || stack.func_77973_b() == Items.field_221858_em;
        }
        if (index == 3) {
            Pair<Integer, Integer> coolant = PowahAPI.getReactorSolidCoolant((IItemProvider)stack.func_77973_b());
            return (Integer)coolant.getLeft() > 0 && (Integer)coolant.getRight() < 2;
        }
        return super.canInsert(index, stack);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (this.field_145850_b == null) {
            return LazyOptional.empty();
        }
        ReactorTile reactor = this.core().orElse(null);
        if (reactor != null) {
            return reactor.getCapability(cap, side);
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }
}

