/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.generator.thermoelectric;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import owmii.lib.block.TileBase;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.item.BlockItemBase;
import owmii.powah.block.generator.GeneratorBlock;
import owmii.powah.block.generator.thermoelectric.ThermoGeneratorTile;
import owmii.powah.inventory.IContainers;
import owmii.powah.inventory.ThermoGenContainer;
import owmii.powah.item.ThermoGeneratorItem;

public class ThermoGeneratorBlock
extends GeneratorBlock
implements IWaterLoggable {
    public static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)ThermoGeneratorBlock.func_208617_a((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)ThermoGeneratorBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)ThermoGeneratorBlock.func_208617_a((double)0.5, (double)1.5, (double)0.5, (double)15.5, (double)2.5, (double)15.5), (VoxelShape)ThermoGeneratorBlock.func_208617_a((double)0.5, (double)3.25, (double)0.5, (double)15.5, (double)4.25, (double)15.5), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_);

    public ThermoGeneratorBlock(Block.Properties properties, int capacity, int transfer, int perTick) {
        super(properties, capacity, transfer, perTick);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ThermoGeneratorTile(this.capacity, this.maxExtract, this.perTick);
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ThermoGeneratorTile) {
            ThermoGeneratorTile genTile = (ThermoGeneratorTile)tile;
            boolean result = FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)genTile.tank);
            if (result) {
                genTile.markDirtyAndSync();
                return true;
            }
        }
        return super.func_220051_a(state, world, pos, player, hand, blockRayTraceResult);
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase inv) {
        if (inv instanceof ThermoGeneratorTile) {
            return new ThermoGenContainer(IContainers.THERMO_GENERATOR, id, playerInventory, (ThermoGeneratorTile)inv);
        }
        return null;
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    @Override
    public BlockItemBase getBlockItem(Item.Properties properties, @Nullable ItemGroup group) {
        return new ThermoGeneratorItem(this, properties, group);
    }

    @Override
    protected boolean hasLitProp() {
        return false;
    }
}

