/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.generator.thermoelectric;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.ITiles;
import owmii.powah.block.generator.GeneratorTile;

public class ThermoGeneratorTile
extends GeneratorTile {
    protected final FluidTank tank = new FluidTank(4000){

        public boolean isFluidValid(FluidStack stack) {
            return PowahAPI.THERMO_COOLANTS.containsKey(stack.getFluid()) && super.isFluidValid(stack);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            ThermoGeneratorTile.this.sync(5);
        }
    };
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public ThermoGeneratorTile(int capacity, int transfer, int perTick) {
        super(ITiles.THERMO_GENERATOR, capacity, transfer, perTick);
    }

    public ThermoGeneratorTile() {
        this(0, 0, 0);
    }

    @Override
    public void readStorable(CompoundNBT compound) {
        this.tank.readFromNBT(compound);
        this.tank.setCapacity(compound.func_74762_e("TankCap"));
        super.readStorable(compound);
    }

    @Override
    public CompoundNBT writeStorable(CompoundNBT compound) {
        this.tank.writeToNBT(compound);
        compound.func_74768_a("TankCap", this.tank.getCapacity());
        return super.writeStorable(compound);
    }

    @Override
    protected void generate() {
        FluidStack fluid;
        if (this.field_145850_b == null) {
            return;
        }
        if (this.nextGen <= 0 && !this.tank.isEmpty() && PowahAPI.THERMO_COOLANTS.containsKey((fluid = this.tank.getFluid()).getFluid())) {
            BlockPos heatPos;
            BlockState state;
            Block block;
            int fluidCooling = PowahAPI.getThermoCoolant(fluid.getFluid());
            if (this.perTick > 0 && PowahAPI.THERMO_HEAT_SOURCES.containsKey(block = (state = this.field_145850_b.func_180495_p(heatPos = this.field_174879_c.func_177977_b())).func_177230_c())) {
                FlowingFluidBlock fluidBlock;
                int heat = PowahAPI.getThermoHeatSource(block);
                if (block instanceof FlowingFluidBlock && !(fluidBlock = (FlowingFluidBlock)block).func_204507_t(state).func_206889_d()) {
                    int level = (Integer)state.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b);
                    heat = (int)((float)heat / ((float)level + 1.0f));
                }
                this.nextGen = this.nextGenCap = (int)((double)heat * (fluidCooling == 1 ? 1.0 : Math.max(1.1, (0.1 + (double)Math.abs(fluidCooling)) * 1.1152)) * (double)this.perTick / 1000.0);
                if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                    this.tank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }

    @Override
    public int perTick() {
        return this.nextGenCap > super.perTick() ? this.nextGenCap : super.perTick();
    }

    @Override
    public int getChargingSlots() {
        return 1;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }
}

