/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.hopper;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.items.CapabilityItemHandler;
import owmii.lib.block.BlockBase;
import owmii.lib.block.TileBase;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.util.Energy;
import owmii.powah.block.PowahBlock;
import owmii.powah.block.hopper.EnergyHopperTile;
import owmii.powah.inventory.EnergyHopperContainer;
import owmii.powah.inventory.IContainers;

public class EnergyHopperBlock
extends PowahBlock
implements IWaterLoggable {
    public static final Map<Direction, VoxelShape> VOXEL_SHAPES = new HashMap<Direction, VoxelShape>();

    public EnergyHopperBlock(Block.Properties properties, int capacity, int transfer) {
        super(properties, capacity, transfer, transfer);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VOXEL_SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnergyHopperTile(this.capacity, this.maxReceive);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos blockpos = pos.func_177972_a(direction);
        BlockState state1 = worldIn.func_180495_p(blockpos);
        TileEntity tile = worldIn.func_175625_s(blockpos);
        return (tile instanceof IInventory || tile != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).isPresent()) && !Energy.isPresent((TileEntity)tile, (Direction)direction);
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase inv) {
        if (inv instanceof EnergyHopperTile) {
            return new EnergyHopperContainer(IContainers.ENERGY_HOPPER, id, playerInventory, (EnergyHopperTile)inv);
        }
        return null;
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    protected BlockBase.FacingType getFacingType() {
        return BlockBase.FacingType.ALL;
    }

    static {
        VOXEL_SHAPES.put(Direction.UP, EnergyHopperBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0));
        VOXEL_SHAPES.put(Direction.DOWN, EnergyHopperBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        VOXEL_SHAPES.put(Direction.NORTH, EnergyHopperBlock.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0));
        VOXEL_SHAPES.put(Direction.SOUTH, EnergyHopperBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0));
        VOXEL_SHAPES.put(Direction.EAST, EnergyHopperBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0));
        VOXEL_SHAPES.put(Direction.WEST, EnergyHopperBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    }
}

