/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.transmitter;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import owmii.lib.block.BlockBase;
import owmii.lib.block.TileBase;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.util.Energy;
import owmii.powah.api.cable.ICable;
import owmii.powah.block.IBlocks;
import owmii.powah.block.PowahBlock;
import owmii.powah.block.transmitter.PlayerTransmitterTile;
import owmii.powah.inventory.IContainers;
import owmii.powah.inventory.PlayerTransmitterContainer;

public class PlayerTransmitterBlock
extends PowahBlock
implements IWaterLoggable {
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();
    private final int slots;
    private final boolean acrossDim;

    public PlayerTransmitterBlock(Block.Properties properties, int capacity, int transfer, int slots, boolean acrossDim) {
        super(properties, capacity, transfer, transfer);
        this.slots = slots;
        this.acrossDim = acrossDim;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.DOWN)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PlayerTransmitterTile(this.capacity, this.maxReceive, this.acrossDim);
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase inv) {
        if (inv instanceof PlayerTransmitterTile) {
            if (this == IBlocks.PLAYER_TRANSMITTER) {
                return new PlayerTransmitterContainer(IContainers.PLAYER_TRANSMITTER, id, playerInventory, (PlayerTransmitterTile)inv, this.slots);
            }
            if (this == IBlocks.PLAYER_TRANSMITTER_DIM) {
                return new PlayerTransmitterContainer(IContainers.PLAYER_TRANSMITTER_DIM, id, playerInventory, (PlayerTransmitterTile)inv, this.slots);
            }
        }
        return null;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos blockpos = pos.func_177972_a(direction);
        BlockState state1 = worldIn.func_180495_p(blockpos);
        TileEntity tile = worldIn.func_175625_s(blockpos);
        return state1.func_177230_c() instanceof ICable || tile != null && !(tile instanceof PlayerTransmitterTile) && Energy.getForgeEnergy((TileEntity)tile, (Direction)direction).isPresent();
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public int getSlots() {
        return this.slots;
    }

    public boolean isAcrossDim() {
        return this.acrossDim;
    }

    protected BlockBase.FacingType getFacingType() {
        return BlockBase.FacingType.ALL;
    }

    static {
        SHAPES.put(Direction.DOWN, PlayerTransmitterBlock.func_208617_a((double)10.0, (double)0.0, (double)10.0, (double)6.0, (double)14.0, (double)6.0));
        SHAPES.put(Direction.UP, PlayerTransmitterBlock.func_208617_a((double)10.0, (double)2.0, (double)10.0, (double)6.0, (double)16.0, (double)6.0));
        SHAPES.put(Direction.SOUTH, VoxelShapes.func_197878_a((VoxelShape)PlayerTransmitterBlock.func_208617_a((double)10.0, (double)6.0, (double)12.0, (double)6.0, (double)16.0, (double)8.0), (VoxelShape)PlayerTransmitterBlock.func_208617_a((double)10.0, (double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        SHAPES.put(Direction.NORTH, VoxelShapes.func_197878_a((VoxelShape)PlayerTransmitterBlock.func_208617_a((double)10.0, (double)6.0, (double)8.0, (double)6.0, (double)16.0, (double)4.0), (VoxelShape)PlayerTransmitterBlock.func_208617_a((double)10.0, (double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        SHAPES.put(Direction.EAST, VoxelShapes.func_197878_a((VoxelShape)PlayerTransmitterBlock.func_208617_a((double)12.0, (double)6.0, (double)10.0, (double)8.0, (double)16.0, (double)6.0), (VoxelShape)PlayerTransmitterBlock.func_208617_a((double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0, (double)6.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        SHAPES.put(Direction.WEST, VoxelShapes.func_197878_a((VoxelShape)PlayerTransmitterBlock.func_208617_a((double)8.0, (double)6.0, (double)10.0, (double)4.0, (double)16.0, (double)6.0), (VoxelShape)PlayerTransmitterBlock.func_208617_a((double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)6.0), (IBooleanFunction)IBooleanFunction.field_223244_o_));
    }
}

