/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.transmitter;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.world.dimension.DimensionType;
import owmii.lib.block.BlockBase;
import owmii.lib.util.Energy;
import owmii.lib.util.Player;
import owmii.powah.block.ITiles;
import owmii.powah.block.PowahTile;
import owmii.powah.block.transmitter.PlayerTransmitterBlock;
import owmii.powah.compat.curios.CuriosCompat;
import owmii.powah.item.BindingCardItem;

public class PlayerTransmitterTile
extends PowahTile {
    private boolean acrossDim;

    public PlayerTransmitterTile(int capacity, int transfer, boolean acrossDim) {
        super(ITiles.PLAYER_TRANSMITTER, capacity, transfer, transfer, false);
        this.acrossDim = acrossDim;
        this.inv.add(2);
    }

    public PlayerTransmitterTile() {
        this(0, 0, false);
    }

    @Override
    public void readStorable(CompoundNBT compound) {
        super.readStorable(compound);
        this.acrossDim = compound.func_74767_n("AcrossDimension");
    }

    @Override
    public CompoundNBT writeStorable(CompoundNBT compound) {
        compound.func_74757_a("AcrossDimension", this.acrossDim);
        return super.writeStorable(compound);
    }

    @Override
    protected boolean postTicks() {
        int[] i = new int[]{0};
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (this.internal.hasEnergy()) {
            for (int i1 : this.nonBuiltInSlots()) {
                ItemStack stack = this.inv.getStackInSlot(i1);
                if (!(stack.func_77973_b() instanceof BindingCardItem)) continue;
                BindingCardItem item = (BindingCardItem)stack.func_77973_b();
                item.getPlayer(stack).ifPresent(player -> {
                    DimensionType type = this.field_145850_b.field_73011_w.func_186058_p();
                    if (this.acrossDim || player.field_71093_bK.equals(type)) {
                        int received;
                        int amount;
                        for (ItemStack stack1 : Player.invStacks((PlayerEntity)player)) {
                            amount = Math.min(this.internal.getMaxExtract(), this.internal.getEnergyStored());
                            received = Energy.receive((ItemStack)stack1, (int)amount, (boolean)false);
                            i[0] = i[0] + this.extractEnergy(received, false, null);
                        }
                        for (ItemStack stack1 : CuriosCompat.getAllStacks((PlayerEntity)player)) {
                            amount = Math.min(this.internal.getMaxExtract(), this.internal.getEnergyStored());
                            received = Energy.receive((ItemStack)stack1, (int)amount, (boolean)false);
                            i[0] = i[0] + this.extractEnergy(received, false, null);
                        }
                    }
                });
            }
        }
        return i[0] > 0;
    }

    @Override
    protected PowahTile.ExtractionType getExtractionType() {
        return PowahTile.ExtractionType.OFF;
    }

    @Override
    public boolean keepInventory() {
        return false;
    }

    @Override
    public boolean canInsert(int index, ItemStack stack) {
        if (this.field_145850_b == null || !(stack.func_77973_b() instanceof BindingCardItem)) {
            return false;
        }
        if (this.getBlock() instanceof PlayerTransmitterBlock && index == 1 && ((PlayerTransmitterBlock)this.getBlock()).getSlots() < 2) {
            return false;
        }
        return stack.func_77978_p() != null && stack.func_77978_p().func_186855_b("BindedPlayerId");
    }

    @Override
    public boolean isEnergyPresent(@Nullable Direction side) {
        return side != null && side.equals((Object)this.func_195044_w().func_177229_b((IProperty)BlockBase.FACING));
    }
}

