/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.book.content.page;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.MavenVersionStringHelper;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import owmii.lib.client.screen.botton.IconButton;
import owmii.lib.client.util.GUI;
import owmii.powah.book.content.BookEntry;
import owmii.powah.book.content.BookIcon;
import owmii.powah.book.content.page.BookImage;
import owmii.powah.book.content.page.IBookInfo;
import owmii.powah.book.content.page.Paragraph;
import owmii.powah.client.screen.book.PowahBookScreen;

public class BookPage {
    private ItemStack stack = ItemStack.field_190927_a;
    private Map<String, Object[]> infoBox = new HashMap<String, Object[]>();
    private List<BookImage> images = new ArrayList<BookImage>();
    private List<Paragraph> paragraphs = new ArrayList<Paragraph>();
    private List<BookEntry> entries = new ArrayList<BookEntry>();
    private boolean isHome;

    public static BookPage create() {
        return new BookPage();
    }

    public BookPage item(IItemProvider item) {
        return this.item(new ItemStack(item));
    }

    public BookPage item(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public BookPage text() {
        if (!this.stack.func_190926_b()) {
            ResourceLocation rl = this.stack.func_77973_b().getRegistryName();
            Objects.requireNonNull(rl);
            this.paragraphs.add(Paragraph.text(rl.func_110623_a(), new Object[0]));
        }
        return this;
    }

    public BookPage info() {
        if (!this.stack.func_190926_b() && this.stack.func_77973_b() instanceof IBookInfo) {
            this.infoBox = ((IBookInfo)this.stack.func_77973_b()).getBookInfo(this.stack, new HashMap<String, Object[]>());
        }
        return this;
    }

    public BookPage title(String title) {
        this.paragraphs.add(Paragraph.title(title));
        return this;
    }

    public BookPage text(String text, Object ... args) {
        this.paragraphs.add(Paragraph.text(text, args));
        return this;
    }

    public BookPage paragraph(String key, Object ... args) {
        this.paragraphs.add(Paragraph.create(key, key, args));
        return this;
    }

    public BookPage image(String path, int width, int height) {
        this.images.add(BookImage.create(path, width, height));
        return this;
    }

    public BookPage add(BookEntry entry) {
        this.entries.add(entry);
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void init(PowahBookScreen screen) {
        for (int i = 0; i < 8; ++i) {
            int index;
            for (int j = 0; j < 6 && (index = j + i * 6) < this.entries.size(); ++j) {
                BookEntry entry = this.entries.get(index);
                ItemStack stack = entry.getIcon().getStack();
                screen.addButton((Widget)new IconButton(screen.x + 13 + j * 29, screen.y + 13 + i * 29, 24, 24, 196, 0, 0, PowahBookScreen.GUI_TEXTURE, b -> screen.mc.func_147108_a((Screen)new PowahBookScreen(entry.setMain(screen.entry.getMain()), 0).setPrevScreen(screen)), (Screen)screen).tooltip(I18n.func_135052_a((String)entry.getTitle(), (Object[])new Object[0]), new Object[0]));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PowahBookScreen screen, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        if (this.isHome) {
            ModList.get().getModContainerById("powah").ifPresent(o -> {
                IModInfo info = o.getModInfo();
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)(-((float)screen.w / 2.0f)), (float)-50.0f, (float)0.0f);
                GlStateManager.scalef((float)2.0f, (float)2.0f, (float)1.0f);
                String s = info.getDisplayName() + "!";
                fr.func_211126_b(s, (float)screen.w / 2.0f - (float)fr.func_78256_a(s) / 2.0f, 50.0f, 0x444444);
                GlStateManager.popMatrix();
                GlStateManager.pushMatrix();
                String s2 = "v" + MavenVersionStringHelper.artifactVersionToString((ArtifactVersion)info.getVersion());
                fr.func_211126_b(s2, (float)screen.w / 2.0f - (float)fr.func_78256_a(s2) / 2.0f, 72.0f, 0x777777);
                String s3 = I18n.func_135052_a((String)"book.powah.title.welcome.back", (Object[])new Object[]{screen.mc.field_71439_g.func_200200_C_().getString()});
                fr.func_211126_b(s3, (float)screen.w / 2.0f - (float)fr.func_78256_a(s3) / 2.0f, 140.0f, 10045789);
                GlStateManager.popMatrix();
            });
            return;
        }
        int i = 0;
        for (BookImage image : this.images) {
            mc.field_71446_o.func_110577_a(image.getLocation());
            int w = image.getWidth();
            int h = image.getHeight();
            AbstractGui.blit((int)8, (int)8, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
            i += h + 2;
        }
        if (!this.stack.func_190926_b()) {
            GlStateManager.pushMatrix();
            float scale = 1.5f;
            int x = (int)((float)screen.w / 2.0f - 12.0f);
            int y = 12;
            GlStateManager.scalef((float)scale, (float)scale, (float)1.0f);
            mc.field_71446_o.func_110577_a(new ResourceLocation("powah", "textures/gui/book/background.png"));
            screen.blit((int)((float)x / scale) - 4, y - 4, 196, 0, 24, 24);
            RenderHelper.func_74520_c();
            mc.func_175599_af().func_180450_b(this.stack, (int)((float)x / scale), y);
            if (GUI.isMouseOver((double)mouseX, (double)mouseY, (int)(screen.x + x), (int)((int)((float)screen.y + (float)y * 1.5f)), (float)24.0f, (float)24.0f)) {
                screen.hoveredStack = this.stack;
            } else if (screen.hoveredStack.func_77969_a(this.stack)) {
                screen.hoveredStack = ItemStack.field_190927_a;
            }
            GlStateManager.popMatrix();
            String s = this.stack.func_200301_q().getString();
            fr.func_211126_b(s, (float)screen.w / 2.0f - (float)fr.func_78256_a(s) / 2.0f, 56.0f, 1989532);
            i += 64;
        }
        boolean flag = false;
        for (Map.Entry<String, Object[]> entry : this.infoBox.entrySet()) {
            fr.func_211126_b(I18n.func_135052_a((String)entry.getKey(), (Object[])entry.getValue()), 10.0f, (float)(10 + i), 3687740);
            i += 14;
            flag = true;
        }
        if (flag) {
            i += 4;
        }
        for (Paragraph paragraph : this.paragraphs) {
            String title = paragraph.getTitle();
            String text = paragraph.getText();
            Object[] args = paragraph.getArgs();
            if (!title.isEmpty()) {
                fr.func_211126_b(I18n.func_135052_a((String)title, (Object[])new Object[0]), 9.0f, (float)(12 + i), 1989532);
                i += 15;
            }
            if (text.isEmpty()) continue;
            fr.func_78279_b(I18n.func_135052_a((String)text, (Object[])args), 9, 10 + i, screen.w - 16, 3687740);
            i += paragraph.height(screen.w - 16);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postRender(PowahBookScreen screen, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        for (int ii = 0; ii < 8; ++ii) {
            for (int j = 0; j < 6; ++j) {
                int index = j + ii * 6;
                if (index >= this.entries.size()) continue;
                BookEntry entry = this.entries.get(index);
                BookIcon icon = entry.getIcon();
                if (icon.getType().equals((Object)BookIcon.Type.ITEM)) {
                    RenderHelper.func_74520_c();
                    mc.func_175599_af().func_180450_b(icon.getStack(), 12 + j * 29 + 5, 17 + ii * 29);
                    RenderHelper.func_74518_a();
                    continue;
                }
                mc.field_71446_o.func_110577_a(icon.getLocation());
                AbstractGui.blit((int)(12 + j * 29 + 5), (int)(17 + ii * 29), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public BookPage setHome() {
        this.isHome = true;
        return this;
    }
}

