/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.renderer.tile;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.util.Energy;
import owmii.powah.block.cable.CableBlock;
import owmii.powah.block.cable.CableTile;
import owmii.powah.client.model.CableConnector;
import owmii.powah.client.model.CableFaceModel;
import owmii.powah.item.WrenchItem;

@OnlyIn(value=Dist.CLIENT)
public class CableRenderer
extends TileEntityRenderer<CableTile> {
    public static final ResourceLocation FC = new ResourceLocation("powah", "textures/ter/cable_face_all.png");
    private static final CableConnector CONNECTOR = new CableConnector();
    private static final CableFaceModel MODEL = new CableFaceModel();

    public void render(CableTile cable, double x, double y, double z, float partialTicks, int destroyStage) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (cable.func_145831_w() != null) {
            World world = cable.func_145831_w();
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)x, (double)y, (double)z);
            GlStateManager.translatef((float)0.5f, (float)-0.5f, (float)0.5f);
            GlStateManager.enableRescaleNormal();
            for (Direction side : cable.energySides) {
                BlockPos pos = cable.func_174877_v().func_177972_a(side);
                BlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof CableBlock || !Energy.isPresent((TileEntity)this.func_178459_a().func_175625_s(pos), (Direction)side) || !cable.isOut(side) && !cable.isIn(side)) continue;
                this.func_147499_a(new ResourceLocation("powah", "textures/block/" + Objects.requireNonNull(cable.getBlock().getRegistryName()).func_110623_a().toLowerCase() + "_te.png"));
                CONNECTOR.render(side, 0.0625f);
                ItemStack stack = player.func_184614_ca();
                String s = cable.getSideConfig().getPowerMode(side).name().toLowerCase();
                if (stack.func_77973_b() instanceof WrenchItem) {
                    this.func_147499_a(new ResourceLocation("powah", "textures/ter/cable_face_" + s + ".png"));
                } else {
                    this.func_147499_a(FC);
                }
                MODEL.render(side, 0.0625f);
            }
            GlStateManager.disableRescaleNormal();
            GlStateManager.popMatrix();
        }
    }
}

