/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.renderer.tile;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.util.math.V3d;
import owmii.powah.api.wrench.IWrench;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.client.model.EnergyChargeModel;

@OnlyIn(value=Dist.CLIENT)
public class EnergizingRodRenderer
extends TileEntityRenderer<EnergizingRodTile> {
    public static final EnergyChargeModel CHARGE_MODEL = new EnergyChargeModel();
    public static final ResourceLocation CHARGE_TEXTURE = new ResourceLocation("powah", "textures/ter/energy_charge.png");
    public static final ResourceLocation BEAM_TEXTURE = new ResourceLocation("powah", "textures/ter/beam.png");

    public void render(EnergizingRodTile rod, double x, double y, double z, float partialTicks, int destroyStage) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.depthMask((boolean)false);
        double f0 = Math.max(rod.coolDown.getTicks() / (double)((float)rod.coolDown.getMax()), 0.0);
        double f1 = 0.5 + f0 / 5.0;
        GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
        RenderHelper.func_74518_a();
        GlStateManager.pushMatrix();
        GlStateManager.scaled((double)f1, (double)f1, (double)f1);
        this.func_147499_a(CHARGE_TEXTURE);
        CHARGE_MODEL.render(0.0625f);
        GlStateManager.popMatrix();
        ClientPlayerEntity player = mc.field_71439_g;
        ItemStack mainHand = player.func_184614_ca();
        ItemStack offHand = player.func_184592_cb();
        boolean flag = false;
        if (mainHand.func_77973_b() instanceof IWrench) {
            flag = ((IWrench)mainHand.func_77973_b()).getWrenchMode(mainHand).link();
        }
        if (offHand.func_77973_b() instanceof IWrench && !flag) {
            flag = ((IWrench)offHand.func_77973_b()).getWrenchMode(offHand).link();
        }
        V3d pos = V3d.from((Vec3i)rod.func_174877_v());
        V3d orbPos = V3d.from((Vec3i)rod.getOrbPos()).up(0.1);
        if ((rod.hasOrb() && rod.coolDown.ended() || flag) && !rod.getOrbPos().equals((Object)BlockPos.field_177992_a)) {
            this.func_147499_a(BEAM_TEXTURE);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.texParameter((int)3553, (int)10242, (int)10497);
            GlStateManager.texParameter((int)3553, (int)10243, (int)10497);
            GlStateManager.disableCull();
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)240.0f, (float)240.0f);
            float f2 = 1.0f;
            float f3 = f2 * 0.5f % 1.0f;
            Vec3d vec3d2 = pos.func_178788_d((Vec3d)orbPos);
            double d0 = vec3d2.func_72433_c();
            vec3d2 = vec3d2.func_72432_b();
            float f5 = (float)Math.acos(vec3d2.field_72448_b);
            float f6 = (float)Math.atan2(vec3d2.field_72449_c, vec3d2.field_72450_a);
            GlStateManager.rotatef((float)((1.5707964f - f6) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)(f5 * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            double d1 = (double)f2 * 0.0;
            double d12 = Math.cos(d1 + Math.PI) * 0.12;
            double d13 = Math.sin(d1 + Math.PI) * 0.12;
            double d14 = Math.cos(d1) * 0.12;
            double d15 = Math.sin(d1) * 0.12;
            double d16 = Math.cos(d1 + 1.5707963267948966) * 0.12;
            double d17 = Math.sin(d1 + 1.5707963267948966) * 0.12;
            double d18 = Math.cos(d1 + 4.71238898038469) * 0.12;
            double d19 = Math.sin(d1 + 4.71238898038469) * 0.12;
            double d22 = f3 - 1.0f;
            double d23 = d0 * 5.05 + d22;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b(d12, 0.0, d13).func_187315_a(1.0, d23).func_181669_b(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(d12, -d0, d13).func_187315_a(1.0, d22).func_181669_b(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(d14, -d0, d15).func_187315_a(0.0, d22).func_181669_b(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(d14, 0.0, d15).func_187315_a(0.0, d23).func_181669_b(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(d16, 0.0, d17).func_187315_a(1.0, d23).func_181669_b(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(d16, -d0, d17).func_187315_a(1.0, d22).func_181669_b(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(d18, -d0, d19).func_187315_a(0.0, d22).func_181669_b(255, 255, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(d18, 0.0, d19).func_187315_a(0.0, d23).func_181669_b(255, 255, 255, 255).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.enableCull();
        }
        RenderHelper.func_74519_b();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    public boolean isGlobalRenderer(EnergizingRodTile te) {
        return te.hasOrb() && te.coolDown.ended();
    }
}

