/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.renderer.tile;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import owmii.powah.block.generator.magmatic.MagmaticGenTile;

@OnlyIn(value=Dist.CLIENT)
public class MagmaticGenRenderer
extends TileEntityRenderer<MagmaticGenTile> {
    public void render(MagmaticGenTile tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        Fluid fluid;
        FluidAttributes fa;
        ResourceLocation still;
        FluidTank tank = tileEntityIn.getTank();
        FluidStack fluidStack = tank.getFluid();
        if (!fluidStack.isEmpty() && (still = (fa = (fluid = fluidStack.getFluid()).getAttributes()).getStill(fluidStack)) != null) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)x, (double)(y + (double)0.51f), (double)z);
            RenderHelper.func_74518_a();
            float fill = (float)tank.getFluidAmount() * 0.45f / (float)tank.getCapacity();
            GlStateManager.translated((double)0.5, (double)fill, (double)0.5);
            AtlasTexture textureMap = Minecraft.func_71410_x().func_147117_R();
            TextureAtlasSprite sprite = textureMap.func_195424_a(still);
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            int color = fa.getColor(fluidStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            GlStateManager.color3f((float)red, (float)green, (float)blue);
            int j3 = 0xA000A0;
            int k3 = j3 >> 16 & 0xFFFF;
            int l3 = j3 & 0xFFFF;
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)k3, (float)l3);
            this.func_147499_a(AtlasTexture.field_110575_b);
            MagmaticGenRenderer.renderQuad(sprite, 0.65);
            RenderHelper.func_74519_b();
            GlStateManager.popMatrix();
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderQuad(TextureAtlasSprite texture, double dim) {
        float f0 = texture.func_94209_e();
        float f1 = texture.func_94212_f();
        float f2 = texture.func_94206_g();
        float f3 = texture.func_94210_h();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        buffer.func_181662_b(-(dim /= 2.0), 0.0, -dim).func_187315_a((double)f0, (double)f3).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_181662_b(-dim, 0.0, dim).func_187315_a((double)f1, (double)f3).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_181662_b(dim, 0.0, dim).func_187315_a((double)f1, (double)f2).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_181662_b(dim, 0.0, -dim).func_187315_a((double)f0, (double)f2).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
    }
}

