/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.renderer.tile;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.client.model.CubeModel;
import owmii.powah.block.generator.reactor.ReactorTile;
import owmii.powah.client.model.ReactorModel;

@OnlyIn(value=Dist.CLIENT)
public class ReactorRenderer
extends TileEntityRenderer<ReactorTile> {
    public static final CubeModel CUBE_MODEL = new CubeModel(16);
    private static final ReactorModel REACTOR_MODEL = new ReactorModel();

    public void render(ReactorTile te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!te.func_145830_o()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        String suffix = Objects.requireNonNull(te.getBlock().getRegistryName()).func_110623_a().substring(7);
        if (!te.isBuilt()) {
            this.func_147499_a(new ResourceLocation("powah", "textures/ter/reactor_block" + suffix + ".png"));
            CUBE_MODEL.render();
        } else if (te.isCore()) {
            GlStateManager.translated((double)0.0, (double)-1.0, (double)0.0);
            this.func_147499_a(new ResourceLocation("powah", "textures/ter/reactor" + suffix + ".png"));
            REACTOR_MODEL.render();
        }
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    public boolean isGlobalRenderer(ReactorTile te) {
        return te.isCore() && te.isBuilt();
    }
}

