/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.Lollipop;
import owmii.lib.client.screen.botton.IconButton;
import owmii.powah.network.packet.SetActiveChannelItem;

@OnlyIn(value=Dist.CLIENT)
public class EnderProbScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("powah", "textures/gui/container/ender_cell.png");
    private static final ResourceLocation GUI_WIDGETS_TEXTURE = new ResourceLocation("powah", "textures/gui/ender_widgets.png");
    protected static CompoundNBT nbt = new CompoundNBT();
    protected IconButton[] channelButtons;
    public int x;
    public int y;
    public int w = 107;
    public int h = 29;
    private int channels = nbt.func_74762_e("TotalChannels");
    private int activeChannel = nbt.func_74762_e("ActiveChannel");

    public EnderProbScreen(ITextComponent titleIn) {
        super(titleIn);
        this.channelButtons = new IconButton[this.channels];
    }

    protected void init() {
        super.init();
        this.x = (this.width - this.w) / 2;
        this.y = (this.height - this.h) / 2;
        block0: for (int l = 0; l < 2; ++l) {
            for (int k = 0; k < 8; ++k) {
                int fi = k + l * 8;
                if (fi >= this.channelButtons.length) break block0;
                this.channelButtons[fi] = new IconButton(this.x + 2 + k * 13, this.y + 2 + l * 13, 12, 12, 0, 60, 12, GUI_WIDGETS_TEXTURE, button -> {
                    Lollipop.NET.toServer((Object)new SetActiveChannelItem(fi));
                    this.activeChannel = fi;
                }, (Screen)this).tooltip("info.powah.channel", TextFormatting.GRAY, new Object[]{"" + TextFormatting.DARK_AQUA + (fi + 1)});
                this.channelButtons[fi].setIconDiff(fi == this.activeChannel ? 12 : 0);
                this.addButton((Widget)this.channelButtons[fi]);
            }
        }
    }

    public void tick() {
        super.tick();
        for (int i = 0; i < this.channelButtons.length; ++i) {
            this.channelButtons[i].setIconDiff(i == this.activeChannel ? 12 : 0);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GUI_TEXTURE);
        this.blit(this.x, this.y, 13, 30, this.w, this.h);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)this.x - 14.0f), (float)((float)this.y - 11.0f), (float)0.0f);
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)1.0f);
        for (int l = 0; l < 2; ++l) {
            for (int k = 0; k < 8; ++k) {
                int fi = k + l * 8;
                this.font.func_211126_b("" + (fi + 1), (float)(42 + k * 26 - (fi >= 9 ? 3 : 0)), (float)(35 + l * 26), fi >= this.channels ? 2246721 : 5410949);
            }
        }
        GlStateManager.popMatrix();
        super.render(mouseX, mouseY, partialTicks);
        for (Widget widget : this.buttons) {
            if (!widget.isHovered()) continue;
            widget.renderToolTip(mouseX, mouseY + 20);
            break;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int i, int i1, int i2) {
        if (super.keyPressed(i, i1, i2)) {
            return true;
        }
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)i, (int)i1);
        if (i == 256 || Minecraft.func_71410_x().field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            return true;
        }
        return false;
    }

    public static void setNbt(CompoundNBT nbt) {
        EnderProbScreen.nbt = nbt;
    }
}

