/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.inventory;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.Lollipop;
import owmii.lib.client.screen.botton.IconButton;
import owmii.lib.util.Energy;
import owmii.lib.util.Text;
import owmii.powah.block.PowahBlock;
import owmii.powah.block.endercell.EnderCellTile;
import owmii.powah.block.energycell.EnergyCellBlock;
import owmii.powah.client.screen.inventory.PowahScreen;
import owmii.powah.energy.PowahStorage;
import owmii.powah.inventory.EnderCellContainer;
import owmii.powah.item.PowahBlockItem;
import owmii.powah.network.packet.SetActiveChannel;

@OnlyIn(value=Dist.CLIENT)
public class EnderCellScreen
extends PowahScreen<EnderCellContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("powah", "textures/gui/container/ender_cell.png");
    private static final ResourceLocation GUI_CONFIG_TEXTURE = new ResourceLocation("powah", "textures/gui/container/ender_configuration.png");
    private static final ResourceLocation GUI_WIDGETS_TEXTURE = new ResourceLocation("powah", "textures/gui/ender_widgets.png");
    protected IconButton[] channelButtons;
    private final EnderCellTile cell;

    public EnderCellScreen(EnderCellContainer container, PlayerInventory playerInventory, ITextComponent name) {
        super(container, playerInventory, name);
        this.cell = (EnderCellTile)container.getTile();
        this.channelButtons = new IconButton[this.cell.getChannels()];
    }

    @Override
    protected void init() {
        super.init();
        block0: for (int l = 0; l < 2; ++l) {
            for (int k = 0; k < 8; ++k) {
                int fi = k + l * 8;
                if (fi >= this.channelButtons.length) break block0;
                this.channelButtons[fi] = new IconButton(this.x + 38 + k * 13, this.y + 32 + l * 13, 12, 12, 0, 60, 12, GUI_WIDGETS_TEXTURE, button -> {
                    Lollipop.NET.toServer((Object)new SetActiveChannel(fi, this.world.field_73011_w.func_186058_p().func_186068_a(), this.cell.func_174877_v()));
                    this.cell.setActiveChannel(fi);
                    this.refresh();
                }, (Screen)this).tooltip("info.powah.channel", TextFormatting.GRAY, new Object[]{"" + TextFormatting.DARK_AQUA + (fi + 1)});
                this.channelButtons[fi].setIconDiff(fi == this.cell.getActiveChannel() ? 12 : 0);
                this.addButton((Widget)this.channelButtons[fi]);
            }
        }
    }

    @Override
    protected void onRefresh() {
        super.onRefresh();
        this.onRefreshDelayed();
    }

    @Override
    protected void onRefreshDelayed() {
        for (int i = 0; i < this.channelButtons.length; ++i) {
            this.channelButtons[i].setIconDiff(i == this.cell.getActiveChannel() ? 12 : 0);
            this.channelButtons[i].visible = !this.sideButtons[0].visible;
        }
    }

    @Override
    protected void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        if (this.sideButtons[0].visible) {
            return;
        }
        GameProfile gm = this.cell.getOwner();
        if (gm != null) {
            this.font.func_175063_a(I18n.func_135052_a((String)"info.powah.owner", (Object[])new Object[]{gm.getName()}), 38.0f, 11.0f, 5410949);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)22.0f, (float)19.0f, (float)0.0f);
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)1.0f);
        for (int l = 0; l < 2; ++l) {
            for (int k = 0; k < 8; ++k) {
                int fi = k + l * 8;
                this.font.func_211126_b("" + (fi + 1), (float)(42 + k * 26 - (fi >= 9 ? 3 : 0)), (float)(35 + l * 26), fi >= this.cell.getChannels() ? 2246721 : 5410949);
            }
        }
        GlStateManager.popMatrix();
    }

    public void func_146977_a(Slot slotIn) {
        PowahBlockItem item;
        PowahBlock block;
        ItemStack stack = slotIn.func_75211_c();
        if (!stack.func_190926_b() && slotIn.func_111238_b() && EnderCellScreen.hasShiftDown() && this.cell.isExtender() && Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString().startsWith("powah:energy_cell") && (block = (item = (PowahBlockItem)stack.func_77973_b()).getBlock()) instanceof EnergyCellBlock) {
            PowahStorage storage = this.cell.getInternal();
            int cap = block.getCapacity();
            int newCap = this.cell.internal.getMaxEnergyStored() + cap;
            int maxCap = 2000000000;
            if (cap <= maxCap && newCap <= maxCap) {
                RenderHelper.func_74518_a();
                this.bindTexture(GUI_WIDGETS_TEXTURE);
                this.blit(slotIn.field_75223_e, slotIn.field_75221_f, 120, 0, 16, 16);
                RenderHelper.func_74520_c();
            }
        }
        super.func_146977_a(slotIn);
    }

    public List<String> getTooltipFromItem(ItemStack stack) {
        PowahBlockItem item;
        PowahBlock block;
        List tooltip = super.getTooltipFromItem(stack);
        if (EnderCellScreen.hasShiftDown() && this.cell.isExtender() && Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString().startsWith("powah:energy_cell") && (block = (item = (PowahBlockItem)stack.func_77973_b()).getBlock()) instanceof EnergyCellBlock) {
            PowahStorage storage = this.cell.getInternal();
            int cap = block.getCapacity();
            int newCap = this.cell.internal.getMaxEnergyStored() + cap;
            int maxCap = 2000000000;
            if (cap <= maxCap && newCap <= maxCap) {
                ArrayList<String> info = new ArrayList<String>();
                info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.channel", (Object[])new Object[]{"" + TextFormatting.DARK_AQUA + (this.cell.getActiveChannel() + 1)}));
                info.add("");
                info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.capacity", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + Text.addCommas((long)this.cell.internal.getMaxEnergyStored())}));
                info.add(TextFormatting.DARK_AQUA + "+ " + Text.addCommas((long)cap) + " FE");
                info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.new.capacity", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + Text.addCommas((long)newCap)}));
                int stored = this.cell.internal.getEnergyStored();
                int stackStored = Energy.getStored((ItemStack)stack);
                if (stackStored + stored > stored) {
                    info.add("");
                    info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.energy.2", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + Text.addCommas((long)stored)}));
                    info.add(TextFormatting.DARK_AQUA + "+ " + Text.addCommas((long)stackStored) + " FE");
                    info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.new.energy", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + Text.addCommas((long)(stackStored + stored))}));
                }
                info.add("");
                info.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"info.powah.shift.to.apply", (Object[])new Object[0]));
                return info;
            }
        }
        return tooltip;
    }

    @Override
    public void renderEnergyBare(int cap, int stored) {
        super.renderEnergyBare(this.cell.internal.getMaxEnergyStored(), this.cell.internal.getEnergyStored());
    }

    @Override
    protected void renderEnergyTooltip(int mouseX, int mouseY, int cap, int stored, int out, int in) {
        super.renderEnergyTooltip(mouseX, mouseY, this.cell.internal.getMaxEnergyStored(), this.cell.internal.getEnergyStored(), out, in);
    }

    @Override
    protected ResourceLocation getSubBackGroundImage() {
        return GUI_TEXTURE;
    }

    @Override
    protected ResourceLocation getConfigBackGroundImage() {
        return GUI_CONFIG_TEXTURE;
    }

    @Override
    protected ResourceLocation getGuiWidgetsTexture() {
        return GUI_WIDGETS_TEXTURE;
    }
}

