/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.Lollipop;
import owmii.lib.client.screen.ContainerScreenBase;
import owmii.lib.client.screen.botton.IconButton;
import owmii.lib.client.util.Draw2D;
import owmii.lib.inventory.slot.SlotBase;
import owmii.lib.util.Text;
import owmii.powah.block.PowahTile;
import owmii.powah.block.generator.GeneratorTile;
import owmii.powah.energy.PowerMode;
import owmii.powah.energy.RedstoneMode;
import owmii.powah.energy.SideConfig;
import owmii.powah.inventory.PowahContainer;
import owmii.powah.network.packet.NextPowerMode;
import owmii.powah.network.packet.NextRedstoneMode;

@OnlyIn(value=Dist.CLIENT)
public abstract class PowahScreen<T extends PowahContainer>
extends ContainerScreenBase<T> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("powah", "textures/gui/container/energy.png");
    private static final ResourceLocation GUI_CONFIG_TEXTURE = new ResourceLocation("powah", "textures/gui/container/configuration.png");
    protected static final ResourceLocation GUI_WIDGETS_TEXTURE = new ResourceLocation("powah", "textures/gui/widgets.png");
    protected IconButton sideConfigButton = IconButton.EMPTY;
    protected IconButton[] sideButtons = new IconButton[7];
    protected IconButton switchRMButton = IconButton.EMPTY;
    protected PowerMode[] powerModes = new PowerMode[7];
    protected RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    protected SideConfig sideConfig;
    protected final PowahTile tile;
    private int refreshDelay;

    public PowahScreen(T container, PlayerInventory playerInventory, ITextComponent name) {
        super(container, playerInventory, name);
        this.tile = (PowahTile)container.getTile();
        this.sideConfig = this.tile.getSideConfig();
        this.field_147000_g = 170;
        for (int i = 0; i < 7; ++i) {
            this.sideButtons[i] = IconButton.EMPTY;
            this.powerModes[i] = PowerMode.NON;
        }
    }

    protected void init() {
        super.init();
        this.addMainButtons(this.x + 155, this.y + 6, 3);
        this.addSideConfig(this.x + 114, this.y + 29, 18);
        this.refresh();
    }

    protected void addMainButtons(int x, int y, int space) {
        this.sideConfigButton = new IconButton(x, y, 15, 15, 0, 0, 15, this.getGuiWidgetsTexture(), button -> {
            this.onSideConfig();
            this.refresh();
        }, (Screen)this).tooltip("info.powah.configuration", TextFormatting.GRAY, new Object[0]);
        this.addButton((Widget)this.sideConfigButton);
        this.redstoneMode = this.tile.getRedstoneMode();
        this.switchRMButton = new IconButton(x, y + space + 15, 15, 15, 15, 0, 15, this.getGuiWidgetsTexture(), button -> {
            Lollipop.NET.toServer((Object)new NextRedstoneMode(this.world.field_73011_w.func_186058_p().func_186068_a(), this.tile.func_174877_v()));
            this.refresh();
        }, (Screen)this).tooltip(this.redstoneMode.getDisplayName(), new Object[0]);
        this.switchRMButton.setIconDiff(this.redstoneMode.getIconXUV());
        this.addButton((Widget)this.switchRMButton);
    }

    protected void addSideConfig(int x, int y, int space) {
        for (int i = 0; i < this.sideButtons.length; ++i) {
            int x1 = x + (i == 4 ? -space : (i == 3 ? space : (i == 5 ? space : (i == 6 ? space : 0))));
            int y1 = y + (i == 0 ? space : (i == 3 ? space : (i == 1 ? -space : (i == 6 ? -space : 0))));
            int fi = i;
            this.powerModes[i] = i == 6 ? PowerMode.ALL : this.sideConfig.getPowerMode(Direction.func_82600_a((int)i));
            this.sideButtons[i] = new IconButton(x1, y1, 15, 15, i == 6 ? 0 : 15, i == 6 ? 30 : 0, 15, this.getGuiWidgetsTexture(), button -> {
                Lollipop.NET.toServer((Object)new NextPowerMode(fi, this.world.field_73011_w.func_186058_p().func_186068_a(), this.tile.func_174877_v()));
                this.powerModes[fi] = fi == 6 ? this.powerModes[fi - 1] : this.sideConfig.getPowerMode(Direction.func_82600_a((int)fi));
                this.refresh();
            }, (Screen)this).tooltip("info.lollipop.side." + (i < 6 ? Direction.func_82600_a((int)i).func_176610_l() : "all"), TextFormatting.GRAY, new Object[]{TextFormatting.DARK_GRAY}).tooltip(this.powerModes[i].getDisplayName(), new Object[0]);
            this.sideButtons[i].setIconDiff(i == 6 ? 0 : this.sideConfig.getPowerMode(Direction.func_82600_a((int)i)).getIconXUV());
            this.sideButtons[i].visible = false;
            this.addButton((Widget)this.sideButtons[i]);
        }
    }

    private void onSideConfig() {
        for (int i = 0; i < this.sideButtons.length; ++i) {
            this.sideButtons[i].visible = !this.sideButtons[i].visible;
        }
    }

    public void tick() {
        super.tick();
        this.onRefresh();
    }

    protected void refresh() {
        this.refreshDelay = 10;
    }

    protected void onRefresh() {
        if (this.refreshDelay > 0) {
            this.sideConfig = this.tile.getSideConfig();
            this.redstoneMode = this.tile.getRedstoneMode();
            this.switchRMButton.setIconDiff(this.redstoneMode.getIconXUV());
            if (this.sideButtons[0].visible) {
                PowerMode powerMode = null;
                boolean flag = false;
                for (int i = 0; i < this.sideButtons.length; ++i) {
                    PowerMode prevPowerMode = powerMode;
                    powerMode = this.sideConfig.getPowerMode(Direction.func_82600_a((int)i));
                    if (prevPowerMode != null && powerMode != prevPowerMode) {
                        flag = true;
                    }
                    this.powerModes[i] = i == 6 ? this.powerModes[i - 1] : powerMode;
                    this.sideButtons[i].setIconDiff(i == 6 ? 0 : this.sideConfig.getPowerMode(Direction.func_82600_a((int)i)).getIconXUV());
                    List list = this.sideButtons[i].getTooltip();
                    list.add(this.powerModes[i].getDisplayName());
                    list.remove(1);
                }
                List list = this.sideButtons[6].getTooltip();
                if (flag && list.size() == 2) {
                    list.remove(1);
                } else if (!flag && list.size() == 1) {
                    list.add(this.powerModes[6].getDisplayName());
                }
            }
            if (this.switchRMButton.isHovered()) {
                List list = this.switchRMButton.getTooltip();
                list.add(this.redstoneMode.getDisplayName());
                list.remove(0);
            }
            this.onRefreshDelayed();
            --this.refreshDelay;
        }
    }

    protected void onRefreshDelayed() {
    }

    protected void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        String s = this.title.func_150254_d();
        int sw = this.font.func_78256_a(s);
        this.font.func_175063_a(s, (float)(-(sw / 2) + this.field_146999_f / 2), -14.0f, 0x777777);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
    }

    protected void drawBackground(float partialTicks, int mouseX, int mouseY) {
        super.drawBackground(partialTicks, mouseX, mouseY);
        if (this.getBackGroundImage() != null) {
            if (!this.sideButtons[0].visible) {
                this.bindTexture(this.getSubBackGroundImage());
            } else {
                this.bindTexture(this.getConfigBackGroundImage());
            }
            this.blit(this.x + (this.hasEnergyBare() ? 23 : 0), this.y, 0, 0, 153 + (this.hasEnergyBare() ? 0 : 23), 72);
        }
        if (this.hasEnergyBare()) {
            int cap = this.tile.getCapacity();
            int stored = this.tile.getEnergyStored();
            this.renderEnergyBare(cap, stored);
        }
    }

    protected boolean hasEnergyBare() {
        return true;
    }

    public void renderEnergyBare(int cap, int stored) {
        if (cap > 0 && stored > 0 && this.getBackGroundImage() != null) {
            this.bindTexture(this.getBackGroundImage());
            Draw2D.gaugeV((int)(this.x + 4), (int)(this.y + 4), (int)14, (int)64, (int)0, (int)170, (int)cap, (int)stored);
        }
    }

    protected boolean hideSlot(Slot slot) {
        return this.sideButtons[0].visible && slot instanceof SlotBase;
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        this.renderEnergyTooltip(mouseX, mouseY, this.tile.getCapacity(), this.tile.getEnergyStored(), this.tile.getMaxExtract(), this.tile.getMaxReceive());
    }

    protected void renderEnergyTooltip(int mouseX, int mouseY, int cap, int stored, int out, int in) {
        if (this.hasEnergyBare() && this.isMouseOver(mouseX - 3, mouseY - 3, 16, 66)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(TextFormatting.GRAY + this.getTitle().getString());
            list.add(" " + TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.stored", (Object[])new Object[]{TextFormatting.DARK_GRAY + Text.addCommas((long)stored), Text.numFormat((long)cap)}));
            if (this.tile instanceof GeneratorTile) {
                list.add(" " + TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.generates", (Object[])new Object[]{TextFormatting.DARK_GRAY + Text.numFormat((long)((GeneratorTile)this.tile).perTick())}));
            }
            list.add(" " + TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.max.io", (Object[])new Object[]{TextFormatting.DARK_GRAY + (in == out ? Text.numFormat((long)out) : (in == 0 || out == 0 ? Text.numFormat((long)Math.max(in, out)) : Text.numFormat((long)in) + "/" + Text.numFormat((long)out)))}));
            this.renderTooltip(list, mouseX, mouseY);
        }
    }

    @Nullable
    protected ResourceLocation getBackGroundImage() {
        return GUI_TEXTURE;
    }

    protected ResourceLocation getConfigBackGroundImage() {
        return GUI_CONFIG_TEXTURE;
    }

    protected ResourceLocation getGuiWidgetsTexture() {
        return GUI_WIDGETS_TEXTURE;
    }

    protected abstract ResourceLocation getSubBackGroundImage();
}

