/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.inventory;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import owmii.lib.client.util.Draw2D;
import owmii.lib.client.util.GL;
import owmii.lib.util.Text;
import owmii.lib.util.Ticker;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.generator.GeneratorTile;
import owmii.powah.block.generator.reactor.ReactorTile;
import owmii.powah.client.screen.inventory.PowahScreen;
import owmii.powah.energy.PowahStorage;
import owmii.powah.inventory.ReactorContainer;

@OnlyIn(value=Dist.CLIENT)
public class ReactorScreen
extends PowahScreen<ReactorContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("powah", "textures/gui/container/reactor.png");
    private static final ResourceLocation GUI_CONFIG_TEXTURE = new ResourceLocation("powah", "textures/gui/container/configuration_reactor.png");

    public ReactorScreen(ReactorContainer container, PlayerInventory playerInventory, ITextComponent name) {
        super(container, playerInventory, name);
    }

    @Override
    protected void addMainButtons(int x, int y, int space) {
        super.addMainButtons(x - 18, y - 1, space);
    }

    @Override
    protected void addSideConfig(int x, int y, int space) {
        super.addSideConfig(x - 18, y, space);
    }

    @Override
    protected void drawBackground(float partialTicks, int mouseX, int mouseY) {
        super.drawBackground(partialTicks, mouseX, mouseY);
        ReactorTile reactor = (ReactorTile)((ReactorContainer)this.field_147002_h).getTile();
        FluidTank tank = reactor.getTank();
        if (!tank.isEmpty()) {
            FluidStack fluidStack = tank.getFluid();
            Fluid fluid = fluidStack.getFluid();
            AtlasTexture textureMap = Minecraft.func_71410_x().func_147117_R();
            FluidAttributes fa = fluid.getAttributes();
            ResourceLocation still = fa.getStill(fluidStack);
            if (still != null) {
                int color = fa.getColor(fluidStack);
                GL.color((int)color);
                TextureAtlasSprite sprite = textureMap.func_195424_a(still);
                this.bindTexture(AtlasTexture.field_110575_b);
                Draw2D.gaugeV((TextureAtlasSprite)sprite, (int)(this.x + 162), (int)(this.y + 4), (int)10, (int)64, (int)tank.getCapacity(), (int)tank.getFluidAmount());
                GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (!this.sideButtons[0].visible) {
            Ticker temp;
            Ticker solidCoolant;
            Ticker redstone;
            Ticker carbon;
            this.bindTexture(GUI_TEXTURE);
            Ticker fuel = reactor.getFuel();
            if (!fuel.isEmpty()) {
                Draw2D.gaugeV((int)(this.x + 101), (int)(this.y + 12), (int)5, (int)48, (int)153, (int)16, (double)fuel.getMax(), (double)fuel.getTicks());
            }
            if (!(carbon = reactor.getCarbon()).isEmpty()) {
                Draw2D.gaugeV((int)(this.x + 48), (int)(this.y + 5), (int)5, (int)16, (int)153, (int)0, (double)carbon.getMax(), (double)carbon.getTicks());
            }
            if (!(redstone = reactor.getRedstone()).isEmpty()) {
                Draw2D.gaugeV((int)(this.x + 48), (int)(this.y + 51), (int)5, (int)16, (int)158, (int)0, (double)redstone.getMax(), (double)redstone.getTicks());
            }
            if (!(solidCoolant = reactor.getSolidCoolant()).isEmpty()) {
                Draw2D.gaugeV((int)(this.x + 147), (int)(this.y + 51), (int)5, (int)16, (int)163, (int)0, (double)solidCoolant.getMax(), (double)solidCoolant.getTicks());
            }
            if (!(temp = reactor.getTemp()).isEmpty()) {
                Draw2D.gaugeV((int)(this.x + 112), (int)(this.y + 27), (int)4, (int)18, (int)168, (int)0, (double)temp.getMax(), (double)temp.getTicks());
            }
        }
    }

    @Override
    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        ReactorTile reactor = (ReactorTile)((ReactorContainer)this.field_147002_h).getTile();
        FluidTank tank = reactor.getTank();
        if (this.isMouseOver(mouseX - 161, mouseY - 3, 12, 66)) {
            boolean b = tank.isEmpty();
            PowahStorage storage = this.tile.getInternal();
            ArrayList<String> list = new ArrayList<String>();
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.coolant", (Object[])new Object[]{b ? TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"info.powah.empty", (Object[])new Object[0]) : TextFormatting.AQUA + tank.getFluid().getDisplayName().getString()}));
            if (!b) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.stored.fluid", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + tank.getFluidAmount(), tank.getCapacity()}));
                int perSeq = PowahAPI.getReactorCoolant(tank.getFluid().getFluid());
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.coldness", (Object[])new Object[]{"" + TextFormatting.AQUA + perSeq}));
            }
            this.renderTooltip(list, mouseX, mouseY);
        }
        Ticker temp = reactor.getTemp();
        if (this.isMouseOver(mouseX - 111, mouseY - 26, 6, 20)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(TextFormatting.GRAY + String.format("%.1f", temp.getTicks()) + " C");
            this.renderTooltip(list, mouseX, mouseY);
        }
        Ticker fuel = reactor.getFuel();
        if (this.isMouseOver(mouseX - 100, mouseY - 11, 7, 50)) {
            boolean b = fuel.isEmpty();
            ArrayList<String> list = new ArrayList<String>();
            list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"item.powah.uraninite", (Object[])new Object[0]));
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.stored.fluid", (Object[])new Object[]{TextFormatting.DARK_GRAY + String.format("%.0f", fuel.getTicks()), String.format("%.0f", fuel.getMax())}));
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.fluid.using", (Object[])new Object[]{TextFormatting.GREEN + String.format("%.4f", reactor.calcConsumption())}));
            this.renderTooltip(list, mouseX, mouseY);
        }
        Ticker carbon = reactor.getCarbon();
        if (this.isMouseOver(mouseX - 47, mouseY - 4, 7, 18)) {
            ArrayList<String> list = new ArrayList<String>();
            boolean b = carbon.isEmpty();
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.carbon", (Object[])new Object[0]));
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.stored.fluid", (Object[])new Object[]{TextFormatting.DARK_GRAY + String.format("%.1f", carbon.getTicks()), String.format("%.1f", carbon.getMax())}));
            list.add("");
            list.add(TextFormatting.DARK_GRAY + "+" + I18n.func_135052_a((String)"info.powah.efficiency", (Object[])new Object[0]));
            list.add(TextFormatting.DARK_RED + (b ? "+0 C" : "+180 C"));
            this.renderTooltip(list, mouseX, mouseY);
        }
        Ticker redstone = reactor.getRedstone();
        if (this.isMouseOver(mouseX - 47, mouseY - 50, 7, 18)) {
            ArrayList<String> list = new ArrayList<String>();
            boolean b = redstone.isEmpty();
            list.add(TextFormatting.RED + I18n.func_135052_a((String)"info.powah.redstone", (Object[])new Object[0]));
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.stored.fluid", (Object[])new Object[]{TextFormatting.DARK_GRAY + String.format("%.1f", redstone.getTicks()), String.format("%.1f", redstone.getMax())}));
            list.add("");
            list.add(TextFormatting.DARK_GRAY + "+" + I18n.func_135052_a((String)"info.powah.production", (Object[])new Object[0]));
            list.add(TextFormatting.DARK_GRAY + "+" + I18n.func_135052_a((String)"info.powah.fuel.consumption", (Object[])new Object[0]));
            list.add(TextFormatting.DARK_RED + (b ? "+0 C" : "+120 C"));
            this.renderTooltip(list, mouseX, mouseY);
        }
        Ticker solidCoolant = reactor.getSolidCoolant();
        if (this.isMouseOver(mouseX - 146, mouseY - 50, 7, 18)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.solid.coolant", (Object[])new Object[0]));
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.stored.fluid", (Object[])new Object[]{TextFormatting.DARK_GRAY + String.format("%.1f", solidCoolant.getTicks()), String.format("%.1f", solidCoolant.getMax())}));
            list.add("" + TextFormatting.AQUA + reactor.getSolidCoolantTemp() + " C");
            this.renderTooltip(list, mouseX, mouseY);
        }
    }

    @Override
    protected void renderEnergyTooltip(int mouseX, int mouseY, int cap, int stored, int out, int in) {
        if (this.isMouseOver(mouseX - 3, mouseY - 3, 16, 66)) {
            ReactorTile reactor = (ReactorTile)((ReactorContainer)this.field_147002_h).getTile();
            ArrayList<String> list = new ArrayList<String>();
            list.add(TextFormatting.GRAY + this.getTitle().getString());
            list.add(" " + TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.stored", (Object[])new Object[]{TextFormatting.DARK_GRAY + Text.addCommas((long)stored), Text.numFormat((long)cap)}));
            if (this.tile instanceof GeneratorTile) {
                list.add(" " + TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.generates", (Object[])new Object[]{TextFormatting.DARK_GRAY + Text.numFormat((long)((long)reactor.calcProduction()))}));
            }
            list.add(" " + TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.max.io", (Object[])new Object[]{TextFormatting.DARK_GRAY + (in == out ? Text.numFormat((long)out) : (in == 0 || out == 0 ? Text.numFormat((long)Math.max(in, out)) : Text.numFormat((long)in) + "/" + Text.numFormat((long)out)))}));
            this.renderTooltip(list, mouseX, mouseY);
        }
    }

    @Override
    protected ResourceLocation getSubBackGroundImage() {
        return GUI_TEXTURE;
    }

    @Override
    protected ResourceLocation getConfigBackGroundImage() {
        return GUI_CONFIG_TEXTURE;
    }
}

