/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.inventory;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import owmii.lib.client.util.Draw2D;
import owmii.lib.client.util.GL;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.generator.thermoelectric.ThermoGeneratorTile;
import owmii.powah.client.screen.inventory.PowahScreen;
import owmii.powah.energy.PowahStorage;
import owmii.powah.inventory.ThermoGenContainer;

@OnlyIn(value=Dist.CLIENT)
public class ThermoGenScreen
extends PowahScreen<ThermoGenContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("powah", "textures/gui/container/thermo_generator.png");
    private static final ResourceLocation GUI_CONFIG_TEXTURE = new ResourceLocation("powah", "textures/gui/container/configuration_with_fluid.png");

    public ThermoGenScreen(ThermoGenContainer container, PlayerInventory playerInventory, ITextComponent name) {
        super(container, playerInventory, name);
    }

    @Override
    protected void addMainButtons(int x, int y, int space) {
        super.addMainButtons(x - 23, y, space);
    }

    @Override
    protected void addSideConfig(int x, int y, int space) {
        super.addSideConfig(x - 23, y, space);
    }

    @Override
    protected void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        ThermoGeneratorTile genTile = (ThermoGeneratorTile)((ThermoGenContainer)this.field_147002_h).getTile();
        int percent = genTile.perTick > 0 ? 100 * genTile.nextGen / genTile.perTick : 0;
        this.font.func_211126_b(percent + "% (" + genTile.nextGen + " EF/t)", 29.0f, 10.0f, 0x555555);
    }

    @Override
    protected void drawBackground(float partialTicks, int mouseX, int mouseY) {
        super.drawBackground(partialTicks, mouseX, mouseY);
        ThermoGeneratorTile genTile = (ThermoGeneratorTile)((ThermoGenContainer)this.field_147002_h).getTile();
        FluidTank tank = genTile.getTank();
        if (!tank.isEmpty()) {
            FluidStack fluidStack = tank.getFluid();
            Fluid fluid = fluidStack.getFluid();
            AtlasTexture textureMap = Minecraft.func_71410_x().func_147117_R();
            FluidAttributes fa = fluid.getAttributes();
            ResourceLocation still = fa.getStill(fluidStack);
            if (still != null) {
                int color = fa.getColor(fluidStack);
                GL.color((int)color);
                TextureAtlasSprite sprite = textureMap.func_195424_a(still);
                this.bindTexture(AtlasTexture.field_110575_b);
                Draw2D.gaugeV((TextureAtlasSprite)sprite, (int)(this.x + 158), (int)(this.y + 4), (int)14, (int)64, (int)tank.getCapacity(), (int)tank.getFluidAmount());
                GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    @Override
    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        ThermoGeneratorTile genTile = (ThermoGeneratorTile)((ThermoGenContainer)this.field_147002_h).getTile();
        FluidTank tank = genTile.getTank();
        if (!tank.isEmpty() && this.isMouseOver(mouseX - 157, mouseY - 3, 16, 66)) {
            PowahStorage storage = this.tile.getInternal();
            ArrayList<String> list = new ArrayList<String>();
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.coolant", (Object[])new Object[]{"" + TextFormatting.AQUA + tank.getFluid().getDisplayName().getString()}));
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.stored.fluid", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + tank.getFluidAmount(), tank.getCapacity()}));
            int perSeq = PowahAPI.getThermoCoolant(tank.getFluid().getFluid());
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.coldness", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + perSeq}));
            this.renderTooltip(list, mouseX, mouseY);
        }
    }

    @Override
    protected ResourceLocation getSubBackGroundImage() {
        return GUI_TEXTURE;
    }

    @Override
    protected ResourceLocation getConfigBackGroundImage() {
        return GUI_CONFIG_TEXTURE;
    }
}

