/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.crafttweaker.energizing;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.minecraft.item.crafting.Ingredient;
import org.openzen.zencode.java.ZenCodeType;
import owmii.powah.api.recipe.energizing.EnergizingRecipe;
import owmii.powah.api.recipe.energizing.EnergizingRecipeSorter;
import owmii.powah.api.recipe.energizing.IEnergizingRecipe;

@ZenRegister
@ZenCodeType.Name(value="mods.powah.Energizing")
public class Energizing {
    @ZenCodeType.Method
    public static void addRecipe(IItemStack output, int energy, IIngredient[] ingredients) {
        CraftTweakerAPI.apply((IAction)new Add(output, energy, ingredients));
    }

    @ZenCodeType.Method
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(output));
    }

    @ZenCodeType.Method
    public static void clearAll() {
        CraftTweakerAPI.apply((IAction)new Clear());
    }

    static class Remove
    implements IRuntimeAction {
        private final IItemStack output;

        public Remove(IItemStack output) {
            this.output = output;
        }

        public void apply() {
            EnergizingRecipeSorter.RECIPES.removeIf(recipe -> recipe.getOutput().func_77969_a(this.output.getInternal()));
        }

        public String describe() {
            return "[Powah] Removed Energizing recipes for: " + this.output.getInternal().func_200301_q();
        }
    }

    static class Add
    implements IRuntimeAction {
        private final IEnergizingRecipe recipe;

        public Add(IItemStack output, int energy, IIngredient[] ingredients) {
            ArrayList<Ingredient> ing = new ArrayList<Ingredient>();
            for (IIngredient iIngredient : ingredients) {
                ing.add(iIngredient.asVanillaIngredient());
            }
            this.recipe = new EnergizingRecipe(output.getInternal(), energy, ing.toArray(new Ingredient[0]));
        }

        public void apply() {
            EnergizingRecipeSorter.RECIPES.add(this.recipe);
        }

        public String describe() {
            return "[Powah] Created new Energizing recipe for: " + this.recipe.getOutput().func_200301_q();
        }
    }

    static class Clear
    implements IRuntimeAction {
        Clear() {
        }

        public void apply() {
            EnergizingRecipeSorter.RECIPES.clear();
        }

        public String describe() {
            return "[Powah] Cleared all recipes.";
        }
    }
}

