/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import owmii.powah.api.recipe.energizing.EnergizingRecipeSorter;
import owmii.powah.block.IBlocks;
import owmii.powah.block.energizing.EnergizingRods;
import owmii.powah.block.generator.magmatic.MagmaticGenerators;
import owmii.powah.block.generator.reactor.Reactors;
import owmii.powah.block.generator.thermoelectric.ThermoGenerators;
import owmii.powah.compat.jei.energizing.EnergizingCategory;
import owmii.powah.compat.jei.magmatic.MagmaticCategory;
import owmii.powah.compat.jei.reactor.ReactorCoolantCategory;
import owmii.powah.compat.jei.reactor.ReactorSCoolantCategory;
import owmii.powah.compat.jei.thermo.ThermoCoolantCategory;
import owmii.powah.compat.jei.thermo.ThermoHeatCategory;
import owmii.powah.config.Config;
import owmii.powah.item.IItems;

@JeiPlugin
public class PowahJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new MagmaticCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ThermoCoolantCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ReactorCoolantCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ReactorSCoolantCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ThermoHeatCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EnergizingCategory(helper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)IBlocks.ENERGIZING_ORB), new ResourceLocation[]{EnergizingCategory.ID});
        for (EnergizingRods energizingRods : EnergizingRods.values()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)energizingRods.get()), new ResourceLocation[]{EnergizingCategory.ID});
        }
        for (Enum enum_ : MagmaticGenerators.values()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)((MagmaticGenerators)enum_).get()), new ResourceLocation[]{MagmaticCategory.ID});
        }
        for (Enum enum_ : ThermoGenerators.values()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)((ThermoGenerators)enum_).get()), new ResourceLocation[]{ThermoCoolantCategory.ID});
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)((ThermoGenerators)enum_).get()), new ResourceLocation[]{ThermoHeatCategory.ID});
        }
        for (Enum enum_ : Reactors.values()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)((Reactors)enum_).get()), new ResourceLocation[]{ReactorCoolantCategory.ID});
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)((Reactors)enum_).get()), new ResourceLocation[]{ReactorSCoolantCategory.ID});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(MagmaticCategory.Maker.getBucketRecipes(registration.getIngredientManager()), MagmaticCategory.ID);
        registration.addRecipes(ThermoCoolantCategory.Maker.getBucketRecipes(registration.getIngredientManager()), ThermoCoolantCategory.ID);
        registration.addRecipes(ReactorCoolantCategory.Maker.getBucketRecipes(registration.getIngredientManager()), ReactorCoolantCategory.ID);
        registration.addRecipes(ReactorSCoolantCategory.Maker.getBucketRecipes(registration.getIngredientManager()), ReactorSCoolantCategory.ID);
        registration.addRecipes(ThermoHeatCategory.Maker.getBucketRecipes(registration.getIngredientManager()), ThermoHeatCategory.ID);
        registration.addRecipes(EnergizingRecipeSorter.RECIPES, EnergizingCategory.ID);
        if (((Boolean)Config.GENERAL.capacitor_blazing.get()).booleanValue()) {
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)IItems.CAPACITOR_BLAZING), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"wiki.powah.capacitor_blazing", (Object[])new Object[0])});
        }
        if (((Boolean)Config.GENERAL.capacitor_niotic.get()).booleanValue()) {
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)IItems.CAPACITOR_NIOTIC), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"wiki.powah.capacitor_niotic", (Object[])new Object[0])});
        }
        if (((Boolean)Config.GENERAL.capacitor_spirited.get()).booleanValue()) {
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)IItems.CAPACITOR_SPIRITED), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"wiki.powah.capacitor_spirited", (Object[])new Object[0])});
        }
        if (((Boolean)Config.GENERAL.player_aerial_pearl.get()).booleanValue()) {
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)IItems.PLAYER_AERIAL_PEARL), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"wiki.powah.player_aerial_pearl", (Object[])new Object[0])});
        }
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("powah", "main");
    }
}

