/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.jei.energizing;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import owmii.powah.api.recipe.energizing.EnergizingRecipe;
import owmii.powah.api.recipe.energizing.IEnergizingRecipe;
import owmii.powah.block.IBlocks;

public class EnergizingCategory
implements IRecipeCategory<IEnergizingRecipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("powah", "textures/gui/jei/energizing.png");
    public static final ResourceLocation ID = new ResourceLocation("powah", "energizing");
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public EnergizingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 38).addPadding(1, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)IBlocks.ENERGIZING_ORB));
        this.localizedName = I18n.func_135052_a((String)"gui.powah.jei.category.energizing", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends IEnergizingRecipe> getRecipeClass() {
        return EnergizingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IEnergizingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.getIngredients());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public void setRecipe(IRecipeLayout recipeLayout, IEnergizingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        int size = recipe.getIngredients().size();
        for (int i = 0; i < size; ++i) {
            itemStackGroup.init(i, true, i * 20 + 3, 4);
        }
        itemStackGroup.init(size, false, 136, 4);
        itemStackGroup.set(ingredients);
    }

    public void draw(IEnergizingRecipe recipe, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.func_211126_b(I18n.func_135052_a((String)"info.powah.energy", (Object[])new Object[]{recipe.getEnergy()}), 2.0f, 29.0f, 4735553);
    }
}

