/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.jei.thermo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.FishBucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.generator.thermoelectric.ThermoGenerators;

public class ThermoCoolantCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("powah", "textures/gui/jei/misc.png");
    public static final ResourceLocation ID = new ResourceLocation("powah", "thermo.coolant");
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public ThermoCoolantCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 24).addPadding(1, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ThermoGenerators.BASIC.get()));
        this.localizedName = I18n.func_135052_a((String)"gui.powah.jei.category.coolant", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack(recipe.getFluid(), 1000));
        if (!Items.field_151133_ar.equals(recipe.bucket)) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)recipe.bucket));
        }
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluidStack = iRecipeLayout.getFluidStacks();
        fluidStack.init(0, true, 4, 5);
        fluidStack.set(ingredients);
    }

    public void draw(Recipe recipe, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.func_211126_b(I18n.func_135052_a((String)"info.powah.coldness", (Object[])new Object[]{"" + TextFormatting.BLUE + recipe.coldness}), 30.0f, 9.0f, 0x444444);
    }

    public static class Recipe {
        private final Fluid fluid;
        private final BucketItem bucket;
        private final int coldness;

        public Recipe(BucketItem bucket, int coldness) {
            this.bucket = bucket;
            this.fluid = bucket.getFluid();
            this.coldness = coldness;
        }

        public Recipe(Fluid fluid, int coldness) {
            this.bucket = (BucketItem)Items.field_151133_ar;
            this.fluid = fluid;
            this.coldness = coldness;
        }

        public BucketItem getBucket() {
            return this.bucket;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public int getColdness() {
            return this.coldness;
        }
    }

    public static class Maker {
        public static List<Recipe> getBucketRecipes(IIngredientManager ingredientManager) {
            Collection allItemStacks = ingredientManager.getAllIngredients(VanillaTypes.ITEM);
            ArrayList<Recipe> recipes = new ArrayList<Recipe>();
            allItemStacks.forEach(stack -> {
                BucketItem bucket;
                Fluid fluid;
                if (stack.func_77973_b() instanceof BucketItem && !(stack.func_77973_b() instanceof FishBucketItem) && PowahAPI.THERMO_COOLANTS.containsKey(fluid = (bucket = (BucketItem)stack.func_77973_b()).getFluid())) {
                    recipes.add(new Recipe(bucket, PowahAPI.getThermoCoolant(fluid)));
                }
            });
            ArrayList<Fluid> fluids = new ArrayList<Fluid>(PowahAPI.THERMO_COOLANTS.keySet());
            recipes.forEach(recipe -> fluids.remove(((Recipe)recipe).fluid));
            fluids.forEach(fluid -> recipes.add(new Recipe((Fluid)fluid, PowahAPI.getMagmaticFluidHeat(fluid))));
            return recipes;
        }
    }
}

