/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.config;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import owmii.powah.config.energy.CableConfig;
import owmii.powah.config.energy.EnderCellConfig;
import owmii.powah.config.energy.EnderGateConfig;
import owmii.powah.config.energy.EnergizingConfig;
import owmii.powah.config.energy.EnergyCellConfig;
import owmii.powah.config.energy.FurnatorConfig;
import owmii.powah.config.energy.MagmaticGeneratorConfig;
import owmii.powah.config.energy.MiscEnergyConfig;
import owmii.powah.config.energy.ReactorConfig;
import owmii.powah.config.energy.SolarPanelConfig;
import owmii.powah.config.energy.ThermoGeneratorConfig;

public class Config {
    public static final Marker MARKER = new MarkerManager.Log4jMarker("CONFIG");
    public static final General GENERAL;
    private static final ForgeConfigSpec GENERAL_CONFIG_SPEC;
    public static final EnergyCellConfig CELL_CONFIG;
    private static final ForgeConfigSpec CELL_CONFIG_SPEC;
    public static final EnderCellConfig ENDER_CELL_CONFIG;
    private static final ForgeConfigSpec ENDER_CELL_CONFIG_SPEC;
    public static final EnderGateConfig ENDER_GATE_CONFIG;
    private static final ForgeConfigSpec ENDER_GATE_CONFIG_SPEC;
    public static final FurnatorConfig FURNATOR_CONFIG;
    private static final ForgeConfigSpec FURNATOR_CONFIG_SPEC;
    public static final MagmaticGeneratorConfig MAGMATIC_GENERATOR;
    private static final ForgeConfigSpec MAGMATIC_GENERATOR_CONFIG_SPEC;
    public static final SolarPanelConfig SOLAR_PANEL;
    private static final ForgeConfigSpec SOLAR_PANEL_CONFIG_SPEC;
    public static final ThermoGeneratorConfig THERMO_GEN_CONFIG;
    private static final ForgeConfigSpec THERMO_GEN_CONFIG_SPEC;
    public static final ReactorConfig REACTOR_CONFIG;
    private static final ForgeConfigSpec REACTOR_CONFIG_SPEC;
    public static final CableConfig CABLE_CONFIG;
    private static final ForgeConfigSpec CABLE_CONFIG_SPEC;
    public static final EnergizingConfig ENERGIZING_CONFIG;
    private static final ForgeConfigSpec ENERGIZING_CONFIG_SPEC;
    public static final MiscEnergyConfig MISC_ENERGY;
    private static final ForgeConfigSpec MISC_ENERGY_CONFIG_SPEC;

    public static void setup() {
        Path dir = FMLPaths.CONFIGDIR.get();
        Path configDir = Paths.get(dir.toAbsolutePath().toString(), "powah");
        String energyFolder = "powah/energy";
        Path energyPath = Paths.get(configDir.toAbsolutePath().toString(), "energy");
        try {
            Files.createDirectories(energyPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, GENERAL_CONFIG_SPEC, "powah/general_common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CELL_CONFIG_SPEC, energyFolder + "/energy_cell.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ENDER_CELL_CONFIG_SPEC, energyFolder + "/ender_cell.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ENDER_GATE_CONFIG_SPEC, energyFolder + "/ender_gate.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, FURNATOR_CONFIG_SPEC, energyFolder + "/furnator.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, MAGMATIC_GENERATOR_CONFIG_SPEC, energyFolder + "/magmatic_generator.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, SOLAR_PANEL_CONFIG_SPEC, energyFolder + "/solar_panel.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, THERMO_GEN_CONFIG_SPEC, energyFolder + "/thermo_generator.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, REACTOR_CONFIG_SPEC, energyFolder + "/reactor.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CABLE_CONFIG_SPEC, energyFolder + "/energy_cable.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ENERGIZING_CONFIG_SPEC, energyFolder + "/Energizing.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, MISC_ENERGY_CONFIG_SPEC, energyFolder + "/misc.toml");
    }

    static {
        Pair generalForgeConfigSpecPair = new ForgeConfigSpec.Builder().configure(General::new);
        GENERAL = (General)generalForgeConfigSpecPair.getLeft();
        GENERAL_CONFIG_SPEC = (ForgeConfigSpec)generalForgeConfigSpecPair.getRight();
        Pair cellsForgeConfigSpecPair = new ForgeConfigSpec.Builder().configure(EnergyCellConfig::new);
        CELL_CONFIG = (EnergyCellConfig)cellsForgeConfigSpecPair.getLeft();
        CELL_CONFIG_SPEC = (ForgeConfigSpec)cellsForgeConfigSpecPair.getRight();
        Pair enderCellConfigForgeConfigSpecPair = new ForgeConfigSpec.Builder().configure(EnderCellConfig::new);
        ENDER_CELL_CONFIG = (EnderCellConfig)enderCellConfigForgeConfigSpecPair.getLeft();
        ENDER_CELL_CONFIG_SPEC = (ForgeConfigSpec)enderCellConfigForgeConfigSpecPair.getRight();
        Pair enderGateConfigForgeConfigSpecPair = new ForgeConfigSpec.Builder().configure(EnderGateConfig::new);
        ENDER_GATE_CONFIG = (EnderGateConfig)enderGateConfigForgeConfigSpecPair.getLeft();
        ENDER_GATE_CONFIG_SPEC = (ForgeConfigSpec)enderGateConfigForgeConfigSpecPair.getRight();
        Pair FurnatorsForgeConfigSpecPair = new ForgeConfigSpec.Builder().configure(FurnatorConfig::new);
        FURNATOR_CONFIG = (FurnatorConfig)FurnatorsForgeConfigSpecPair.getLeft();
        FURNATOR_CONFIG_SPEC = (ForgeConfigSpec)FurnatorsForgeConfigSpecPair.getRight();
        Pair MagmaticGeneratorsForgeConfigSpecPair = new ForgeConfigSpec.Builder().configure(MagmaticGeneratorConfig::new);
        MAGMATIC_GENERATOR = (MagmaticGeneratorConfig)MagmaticGeneratorsForgeConfigSpecPair.getLeft();
        MAGMATIC_GENERATOR_CONFIG_SPEC = (ForgeConfigSpec)MagmaticGeneratorsForgeConfigSpecPair.getRight();
        Pair SolarPanelsForgeConfigSpecPair = new ForgeConfigSpec.Builder().configure(SolarPanelConfig::new);
        SOLAR_PANEL = (SolarPanelConfig)SolarPanelsForgeConfigSpecPair.getLeft();
        SOLAR_PANEL_CONFIG_SPEC = (ForgeConfigSpec)SolarPanelsForgeConfigSpecPair.getRight();
        Pair thermoGeneratorConfigForgeConfigSpecPair = new ForgeConfigSpec.Builder().configure(ThermoGeneratorConfig::new);
        THERMO_GEN_CONFIG = (ThermoGeneratorConfig)thermoGeneratorConfigForgeConfigSpecPair.getLeft();
        THERMO_GEN_CONFIG_SPEC = (ForgeConfigSpec)thermoGeneratorConfigForgeConfigSpecPair.getRight();
        Pair reactorConfigForgeConfigSpecPair = new ForgeConfigSpec.Builder().configure(ReactorConfig::new);
        REACTOR_CONFIG = (ReactorConfig)reactorConfigForgeConfigSpecPair.getLeft();
        REACTOR_CONFIG_SPEC = (ForgeConfigSpec)reactorConfigForgeConfigSpecPair.getRight();
        Pair energizingConfigForgeConfigSpecPair = new ForgeConfigSpec.Builder().configure(EnergizingConfig::new);
        ENERGIZING_CONFIG = (EnergizingConfig)energizingConfigForgeConfigSpecPair.getLeft();
        ENERGIZING_CONFIG_SPEC = (ForgeConfigSpec)energizingConfigForgeConfigSpecPair.getRight();
        Pair CablesForgeConfigSpecPair = new ForgeConfigSpec.Builder().configure(CableConfig::new);
        CABLE_CONFIG = (CableConfig)CablesForgeConfigSpecPair.getLeft();
        CABLE_CONFIG_SPEC = (ForgeConfigSpec)CablesForgeConfigSpecPair.getRight();
        Pair miscEnergyForgeConfigSpecPair = new ForgeConfigSpec.Builder().configure(MiscEnergyConfig::new);
        MISC_ENERGY = (MiscEnergyConfig)miscEnergyForgeConfigSpecPair.getLeft();
        MISC_ENERGY_CONFIG_SPEC = (ForgeConfigSpec)miscEnergyForgeConfigSpecPair.getRight();
    }

    public static class General {
        public final ForgeConfigSpec.BooleanValue capacitor_blazing;
        public final ForgeConfigSpec.BooleanValue capacitor_niotic;
        public final ForgeConfigSpec.BooleanValue capacitor_spirited;
        public final ForgeConfigSpec.BooleanValue player_aerial_pearl;
        public final ForgeConfigSpec.BooleanValue oreGen;
        public final ForgeConfigSpec.IntValue poorUraniniteGenChance;
        public final ForgeConfigSpec.IntValue uraniniteGenChance;
        public final ForgeConfigSpec.IntValue denseUraniniteGenChance;
        public final ForgeConfigSpec.IntValue dryIceGenChance;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("World Gen");
            this.oreGen = builder.comment("Enable/Disable ore generation. [default:true]").define("oreGen", true);
            this.poorUraniniteGenChance = builder.comment("Poor Uraninite Ore generation chance").defineInRange("poorUraniniteGenChance", 11, 1, 64);
            this.uraniniteGenChance = builder.comment("Enable/Disable ore generation. [default:true]").defineInRange("uraniniteGenChance", 7, 1, 64);
            this.denseUraniniteGenChance = builder.comment("Enable/Disable ore generation. [default:true]").defineInRange("denseUraniniteGenChance", 3, 1, 64);
            this.dryIceGenChance = builder.comment("Enable/Disable ore generation. [default:true]").defineInRange("dryIceGenChance", 12, 1, 64);
            builder.pop();
            builder.push("Capacitors");
            this.capacitor_blazing = builder.comment(new String[]{"", "Enable this to get Blazing Capacitor by right clicking a blaze with a Large Basic Capacitor. [default:true]"}).define("capacitor_blazing", true);
            this.capacitor_niotic = builder.comment(new String[]{"", "Enable this to get Niotic Capacitor by right clicking a Diamond Ore with a Blazing Capacitor. [default:true]"}).define("capacitor_niotic", true);
            this.capacitor_spirited = builder.comment(new String[]{"", "Enable this to get Spirited Capacitor by right clicking an Emerald Ore with a Niotic Capacitor. [default:true]"}).define("capacitor_spirited", true);
            this.player_aerial_pearl = builder.comment(new String[]{"", "Enable this to get Player Aerial Pearl by right clicking a Zombie or Husk with a Aerial Pearl. [default:true]"}).define("player_aerial_pearl", true);
            builder.pop();
        }
    }
}

