/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.config.energy;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import owmii.powah.block.generator.reactor.Reactors;

public class ReactorConfig {
    public final ForgeConfigSpec.ConfigValue<List<String>> coolantFluids;
    public final ForgeConfigSpec.BooleanValue coolantFluidsAPI;
    public final ForgeConfigSpec.ConfigValue[] caps = new ForgeConfigSpec.ConfigValue[Reactors.values().length];
    public final ForgeConfigSpec.ConfigValue[] transfers = new ForgeConfigSpec.ConfigValue[Reactors.values().length];
    public final ForgeConfigSpec.ConfigValue[] generations = new ForgeConfigSpec.ConfigValue[Reactors.values().length];

    public ReactorConfig(ForgeConfigSpec.Builder builder) {
        this.coolantFluids = builder.comment(new String[]{"", "List of coolant fluids used in a Reactor.", "Fluid registry name = coldness per mb, eg: [\"minecraft:water=1\", \"examplemod:fluid=-1\"]", "Less number more cold, min = -100, max = 1"}).define("coolantFluids", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:water=1"}));
        this.coolantFluidsAPI = builder.comment("Enable this to allow other mods to add their coolant fluids. [default:true]").define("coolantFluidsAPI", true);
        Reactors[] values = Reactors.values();
        for (int i = 0; i < values.length; ++i) {
            Reactors reactors = values[i];
            String name = reactors.name().toLowerCase();
            String cap = name.substring(0, 1).toUpperCase() + name.substring(1);
            if (i == 0) {
                builder.comment("Range: min = 0, max = 2147483647");
            }
            builder.push(cap + " Reactor");
            this.caps[i] = builder.define("capacity", (Object)("" + reactors.capacity));
            this.transfers[i] = builder.define("transfer", (Object)("" + reactors.transfer));
            this.generations[i] = builder.define("genFactor", (Object)("" + reactors.perTick));
            builder.pop();
        }
    }
}

