/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.config.energy;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import owmii.powah.block.generator.thermoelectric.ThermoGenerators;

public class ThermoGeneratorConfig {
    public final ForgeConfigSpec.ConfigValue<List<String>> heatBlocks;
    public final ForgeConfigSpec.BooleanValue heatBlocksAPI;
    public final ForgeConfigSpec.ConfigValue<List<String>> coolantFluids;
    public final ForgeConfigSpec.BooleanValue coolantFluidsAPI;
    public final ForgeConfigSpec.ConfigValue[] caps = new ForgeConfigSpec.ConfigValue[ThermoGenerators.values().length];
    public final ForgeConfigSpec.ConfigValue[] transfers = new ForgeConfigSpec.ConfigValue[ThermoGenerators.values().length];
    public final ForgeConfigSpec.ConfigValue[] generations = new ForgeConfigSpec.ConfigValue[ThermoGenerators.values().length];

    public ThermoGeneratorConfig(ForgeConfigSpec.Builder builder) {
        this.heatBlocks = builder.comment(new String[]{"", "List of heat blocks used under Thermoelectric Generator.", "Block registry name = heat, eg: [\"minecraft:lava=1000\", \"minecraft:magma_block=1200\"]", "Min = 1, max = 2147483647"}).define("solidCoolants", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:lava=1000", "minecraft:magma_block=1200"}));
        this.heatBlocksAPI = builder.comment("Enable this to allow other mods to add their heat blocks. [default:true]").define("heatBlocksAPI", true);
        this.coolantFluids = builder.comment(new String[]{"", "List of coolant fluids used in Thermoelectric Generator.", "Fluid registry name = cooling per mb, eg: [\"minecraft:water=1\", \"examplemod:fluid=-1\"]", "Less number more cold, min = -100, max = 1"}).define("coolantFluids", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:water=1"}));
        this.coolantFluidsAPI = builder.comment("Enable this to allow other mods to add their coolant fluids. [default:true]").define("coolantFluidsAPI", true);
        ThermoGenerators[] values = ThermoGenerators.values();
        for (int i = 0; i < values.length; ++i) {
            ThermoGenerators generators = values[i];
            String name = generators.name().toLowerCase();
            String cap = name.substring(0, 1).toUpperCase() + name.substring(1);
            if (i == 0) {
                builder.comment("Range: min = 0, max = 2147483647");
            }
            builder.push(cap + " Thermoelectric Generator");
            this.caps[i] = builder.define("capacity", (Object)("" + generators.capacity));
            this.transfers[i] = builder.define("transfer", (Object)("" + generators.transfer));
            this.generations[i] = builder.define("perTick", (Object)("" + generators.perTick));
            builder.pop();
        }
    }
}

