/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.energy;

import net.minecraft.item.ItemStack;
import owmii.powah.energy.PowahStorage;

public class ItemPowahStorage
extends PowahStorage {
    private final ItemStack stack;
    private boolean isCreative;

    public ItemPowahStorage(ItemStack stack, int capacity, int maxReceive, int maxExtract, int energy, boolean isCreative) {
        super(capacity, maxReceive, maxExtract, energy);
        this.stack = stack;
        this.isCreative = isCreative;
        if (stack.func_77978_p() != null) {
            this.read(stack.func_77978_p().func_74775_l("lollipop_Storable_NBT"));
            if (isCreative) {
                this.setEnergy(this.getMaxEnergyStored());
            }
        }
        this.setCapacity(capacity);
        this.setMaxExtract(maxExtract);
        this.setMaxReceive(maxReceive);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energy = super.receiveEnergy(maxReceive, simulate);
        if (energy > 0 && !simulate && !this.isCreative) {
            this.write(this.stack.func_190925_c("lollipop_Storable_NBT"));
        }
        return energy;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energy = super.extractEnergy(maxExtract, simulate);
        if (energy > 0 && !simulate && !this.isCreative) {
            this.write(this.stack.func_190925_c("lollipop_Storable_NBT"));
        }
        return energy;
    }

    @Override
    public int setEnergy(int i) {
        if (this.isCreative && i < this.getEnergyStored()) {
            return 0;
        }
        return super.setEnergy(i);
    }

    public int getEnergyStored() {
        return this.isCreative ? this.getMaxEnergyStored() : super.getEnergyStored();
    }

    @Override
    public boolean canReceive() {
        return !this.isCreative && super.canReceive();
    }
}

