/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.energy;

import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.energy.EnergyStorage;

public class PowahStorage
extends EnergyStorage {
    protected int maxReceive;
    protected int maxExtract;

    public PowahStorage(int capacity) {
        this(capacity, capacity);
    }

    public PowahStorage(PowahStorage storage) {
        this(storage.capacity, storage.maxReceive, storage.maxExtract, storage.energy);
    }

    public PowahStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public PowahStorage(int capacity, int maxReceive, int maxExtract) {
        this(capacity, maxReceive, maxExtract, 0);
    }

    public PowahStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public static PowahStorage fromNBT(CompoundNBT compound) {
        return new PowahStorage(0).read(compound);
    }

    public CompoundNBT serialize() {
        return this.write(new CompoundNBT());
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74768_a("FECapacity", this.capacity);
        compound.func_74768_a("FEStored", this.energy);
        compound.func_74768_a("FEMaxReceive", this.maxReceive);
        compound.func_74768_a("FEMaxExtract", this.maxExtract);
        return compound;
    }

    public PowahStorage read(CompoundNBT compound) {
        this.capacity = compound.func_74762_e("FECapacity");
        this.energy = Math.max(0, Math.min(this.capacity, compound.func_74762_e("FEStored")));
        this.maxReceive = compound.func_74762_e("FEMaxReceive");
        this.maxExtract = compound.func_74762_e("FEMaxExtract");
        return this;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.getEnergyStored() > capacity) {
            this.setEnergy(capacity);
        }
    }

    public int getDif() {
        return this.getMaxEnergyStored() - this.getEnergyStored();
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public int consume(int amount) {
        return this.setEnergy(this.getEnergyStored() - amount);
    }

    public int setEnergy(int i) {
        int e;
        this.energy = e = Math.max(0, Math.min(this.capacity, i));
        return e;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    public boolean hasEnergy() {
        return this.energy > 0;
    }

    public boolean isFull() {
        return this.energy >= this.capacity;
    }
}

