/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.energy;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import owmii.powah.block.PowahTile;
import owmii.powah.energy.PowerMode;

public class SideConfig {
    private final PowerMode[] powerMode = new PowerMode[]{PowerMode.NON, PowerMode.NON, PowerMode.NON, PowerMode.NON, PowerMode.NON, PowerMode.NON};
    private final Direction[] sides = Direction.values();
    private final PowahTile tile;

    public SideConfig(PowahTile tile) {
        this.tile = tile;
    }

    public void init() {
        for (Direction side : Direction.values()) {
            if (!this.tile.isEnergyPresent(side)) continue;
            boolean e = this.tile.internal.canExtract() && this.tile.isExtractor();
            boolean r = this.tile.internal.canReceive();
            this.setPowerMode(side, r && e ? PowerMode.ALL : (r ? PowerMode.IN : (e ? PowerMode.OUT : PowerMode.NON)));
        }
    }

    public CompoundNBT write(CompoundNBT compound) {
        for (int i = 0; i < this.sides.length; ++i) {
            Direction side = this.sides[i];
            if (side == null) continue;
            compound.func_74768_a("PowerMode_" + side.func_176745_a(), this.powerMode[i].ordinal());
        }
        return compound;
    }

    public void read(CompoundNBT compound) {
        for (int i = 0; i < this.sides.length; ++i) {
            Direction side = this.sides[i];
            String key = "PowerMode_" + side.func_176745_a();
            if (!compound.func_150297_b(key, 3)) continue;
            this.setPowerMode(side, PowerMode.values()[compound.func_74762_e("PowerMode_" + side.func_176745_a())]);
        }
    }

    public PowerMode getPowerMode(@Nullable Direction side) {
        if (side != null) {
            return this.powerMode[side.func_176745_a()];
        }
        return PowerMode.NON;
    }

    public void setPowerMode(@Nullable Direction side, PowerMode powerMode) {
        if (side != null) {
            this.powerMode[side.func_176745_a()] = powerMode;
        }
    }

    public void nextPowerModeAllSides() {
        int i = -1;
        for (Direction side : Direction.values()) {
            if (!this.tile.isEnergyPresent(side)) continue;
            i = i == -1 ? this.getPowerMode(side).ordinal() + 1 : i;
            PowerMode mode = PowerMode.values()[i > 3 ? 0 : i];
            if (!(this.tile.internal.canExtract() && this.tile.isExtractor() || !mode.isOut())) {
                mode = PowerMode.IN;
            } else if (!this.tile.internal.canReceive() && mode.isIn()) {
                mode = PowerMode.NON.equals((Object)mode) || PowerMode.ALL.equals((Object)mode) ? PowerMode.OUT : PowerMode.NON;
            }
            this.setPowerMode(side, mode);
        }
    }

    public void nextPowerMode(@Nullable Direction side) {
        if (this.tile.isEnergyPresent(side)) {
            int i = this.getPowerMode(side).ordinal() + 1;
            PowerMode mode = PowerMode.values()[i > 3 ? 0 : i];
            if (!(this.tile.internal.canExtract() && this.tile.isExtractor() || !mode.isOut())) {
                mode = PowerMode.IN;
            } else if (!this.tile.internal.canReceive() && mode.isIn()) {
                mode = PowerMode.NON.equals((Object)mode) || PowerMode.ALL.equals((Object)mode) ? PowerMode.OUT : PowerMode.NON;
            }
            this.setPowerMode(side, mode);
        }
    }

    public PowerMode getPowerMode(int i) {
        return this.powerMode[i];
    }
}

