/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import owmii.powah.Powah;
import owmii.powah.api.PowahAPI;
import owmii.powah.config.Config;

public class CoolingFluidHandler {
    private static final Map<Fluid, Integer> THERMO_COOLING_FLUIDS = new HashMap<Fluid, Integer>();
    private static final Map<Fluid, Integer> REACTOR_COOLING_FLUIDS = new HashMap<Fluid, Integer>();

    public static void post() {
        if (((Boolean)Config.THERMO_GEN_CONFIG.coolantFluidsAPI.get()).booleanValue()) {
            THERMO_COOLING_FLUIDS.putAll(PowahAPI.THERMO_COOLANTS);
        }
        if (((Boolean)Config.REACTOR_CONFIG.coolantFluidsAPI.get()).booleanValue()) {
            REACTOR_COOLING_FLUIDS.putAll(PowahAPI.REACTOR_COOLANTS);
        }
        ((List)Config.THERMO_GEN_CONFIG.coolantFluids.get()).forEach(s -> {
            block11: {
                String[] args = s.split("=");
                if (args.length == 2) {
                    String regName = args[0];
                    if (regName.contains(":")) {
                        ResourceLocation rl = new ResourceLocation(regName);
                        if (ModList.get().isLoaded(rl.func_110624_b().toLowerCase())) {
                            try {
                                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(rl);
                                if (fluid != null) {
                                    try {
                                        int coldness = Integer.parseInt(args[1]);
                                        if (coldness < 2 && coldness > -101) {
                                            THERMO_COOLING_FLUIDS.put(fluid, coldness);
                                            Powah.LOGGER.info(Config.MARKER, "Added fluid: {}, with coldness of: {} per mb", (Object)regName, (Object)args[1]);
                                            break block11;
                                        }
                                        Powah.LOGGER.warn(Config.MARKER, "Ignored fluid: {}, with coldness > 1 or < -100: {}", (Object)regName, (Object)args[1]);
                                    }
                                    catch (Exception e) {
                                        Powah.LOGGER.fatal(Config.MARKER, "Ignored fluid: {}, for incorrect args: {}", (Object)regName, (Object)args[1]);
                                        e.printStackTrace();
                                    }
                                    break block11;
                                }
                                Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong fluid registry name {}.", (Object)regName);
                            }
                            catch (Exception e) {
                                Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong fluid registry name {}.", (Object)regName);
                                e.printStackTrace();
                            }
                        } else {
                            Powah.LOGGER.warn(Config.MARKER, "Ignored fluid for missing mod: {}.", (Object)rl.func_110624_b());
                        }
                    } else {
                        Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong fluid registry name {}.", (Object)regName);
                    }
                }
            }
        });
        ((List)Config.REACTOR_CONFIG.coolantFluids.get()).forEach(s -> {
            block11: {
                String[] args = s.split("=");
                if (args.length == 2) {
                    String regName = args[0];
                    if (regName.contains(":")) {
                        ResourceLocation rl = new ResourceLocation(regName);
                        if (ModList.get().isLoaded(rl.func_110624_b().toLowerCase())) {
                            try {
                                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(rl);
                                if (fluid != null) {
                                    try {
                                        int coldness = Integer.parseInt(args[1]);
                                        if (coldness < 2 && coldness > -101) {
                                            REACTOR_COOLING_FLUIDS.put(fluid, coldness);
                                            Powah.LOGGER.info(Config.MARKER, "Added fluid: {}, with coldness of: {} per mb", (Object)regName, (Object)args[1]);
                                            break block11;
                                        }
                                        Powah.LOGGER.warn(Config.MARKER, "Ignored fluid: {}, with coldness > 1 or < -100: {}", (Object)regName, (Object)args[1]);
                                    }
                                    catch (Exception e) {
                                        Powah.LOGGER.fatal(Config.MARKER, "Ignored fluid: {}, for incorrect args: {}", (Object)regName, (Object)args[1]);
                                        e.printStackTrace();
                                    }
                                    break block11;
                                }
                                Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong fluid registry name {}.", (Object)regName);
                            }
                            catch (Exception e) {
                                Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong fluid registry name {}.", (Object)regName);
                                e.printStackTrace();
                            }
                        } else {
                            Powah.LOGGER.warn(Config.MARKER, "Ignored fluid for missing mod: {}.", (Object)rl.func_110624_b());
                        }
                    } else {
                        Powah.LOGGER.fatal(Config.MARKER, "Ignored Wrong fluid registry name {}.", (Object)regName);
                    }
                }
            }
        });
        PowahAPI.THERMO_COOLANTS.clear();
        PowahAPI.THERMO_COOLANTS.putAll(THERMO_COOLING_FLUIDS);
        PowahAPI.REACTOR_COOLANTS.clear();
        PowahAPI.REACTOR_COOLANTS.putAll(REACTOR_COOLING_FLUIDS);
    }
}

