/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.util.Player;
import owmii.powah.block.endercell.EnderCellBlock;
import owmii.powah.client.screen.IScreens;
import owmii.powah.item.PowahBlockItem;

public class EnderCellItem
extends PowahBlockItem {
    private final EnderCellBlock block;

    public EnderCellItem(EnderCellBlock block, Item.Properties properties, @Nullable ItemGroup group) {
        super(block, properties, group);
        this.block = block;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        if (Player.isFake((PlayerEntity)playerIn)) {
            return;
        }
        CompoundNBT tag = stack.func_196082_o();
        if (!tag.func_150297_b("lollipop_Storable_NBT", 10)) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("TotalChannels", this.getBlock().getChannels());
            nbt.func_186854_a("OwnerId", playerIn.func_146103_bH().getId());
            nbt.func_74778_a("OwnerName", playerIn.func_146103_bH().getName());
            nbt.func_74768_a("ActiveChannel", 0);
            tag.func_218657_a("lollipop_Storable_NBT", (INBT)nbt);
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType actionresulttype = this.func_195942_a(new BlockItemUseContext(context));
        return actionresulttype != ActionResultType.SUCCESS ? this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a() : actionresulttype;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        CompoundNBT nbt;
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (Player.isFake((PlayerEntity)playerIn)) {
            return ActionResult.newResult((ActionResultType)ActionResultType.FAIL, (Object)stack);
        }
        CompoundNBT tag = stack.func_196082_o();
        if (!tag.func_150297_b("lollipop_Storable_NBT", 10)) {
            nbt = new CompoundNBT();
            nbt.func_74768_a("TotalChannels", this.getBlock().getChannels());
            nbt.func_186854_a("OwnerId", playerIn.func_146103_bH().getId());
            nbt.func_74778_a("OwnerName", playerIn.func_146103_bH().getName());
            nbt.func_74768_a("ActiveChannel", 0);
            tag.func_218657_a("lollipop_Storable_NBT", (INBT)nbt);
        }
        if (worldIn.field_72995_K) {
            nbt = tag.func_74775_l("lollipop_Storable_NBT");
            IScreens.openEnderNetScreen(stack, nbt);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof PlayerEntity) {
            CompoundNBT stackTag;
            CompoundNBT tag;
            PlayerEntity player = (PlayerEntity)entityIn;
            CompoundNBT compoundNBT = tag = stack.func_77978_p() != null ? stack.func_77978_p() : new CompoundNBT();
            if (tag.func_150297_b("lollipop_Storable_NBT", 10) && (stackTag = tag.func_74775_l("lollipop_Storable_NBT")).func_150297_b("ActiveChannel", 3)) {
                this.oneTimeInfo(player, stack, new TranslationTextComponent("info.powah.channel", new Object[]{"" + TextFormatting.DARK_AQUA + (stackTag.func_74762_e("ActiveChannel") + 1)}).func_211708_a(TextFormatting.GRAY));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<String, Object[]> getBookInfo(ItemStack stack, Map<String, Object[]> lines) {
        Map<String, Object[]> bookInfo = super.getBookInfo(stack, lines);
        bookInfo.put("info.powah.max.channels", new Object[]{this.getBlock().getChannels()});
        return bookInfo;
    }

    @Override
    public EnderCellBlock getBlock() {
        return this.block;
    }
}

