/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import owmii.lib.item.BlockItemBase;
import owmii.lib.util.Text;
import owmii.powah.block.PowahBlock;
import owmii.powah.block.generator.GeneratorBlock;
import owmii.powah.book.content.page.IBookInfo;
import owmii.powah.energy.ItemEnergyProvider;

public class PowahBlockItem
extends BlockItemBase
implements IBookInfo {
    private final PowahBlock block;

    public PowahBlockItem(PowahBlock block, Item.Properties properties, @Nullable ItemGroup group) {
        super((Block)block, properties.func_208103_a(block.isCreative() ? Rarity.RARE : Rarity.COMMON), group);
        this.block = block;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ItemEnergyProvider(stack, this.getBlock().getCapacity(), 0, this.getBlock().getMaxExtract(), this.getBlock().getMaxReceive(), this.getBlock().isCreative());
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getBlock().isCreative() || super.func_77636_d(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<String, Object[]> getBookInfo(ItemStack stack, Map<String, Object[]> lines) {
        if (this.getBlock().getCapacity() > 0) {
            lines.put("info.powah.capacity", new Object[]{Text.addCommas((long)this.getBlock().getCapacity())});
        }
        if (this.getBlock() instanceof GeneratorBlock) {
            lines.put("info.powah.generates", new Object[]{Text.addCommas((long)((GeneratorBlock)this.getBlock()).perTick())});
        }
        int maxIn = this.getBlock().getMaxReceive();
        int maxOut = this.getBlock().getMaxExtract();
        lines.put("info.powah.max.io", new Object[]{maxIn == maxOut ? Text.addCommas((long)maxOut) : (maxIn == 0 || maxOut == 0 ? Text.addCommas((long)Math.max(maxIn, maxOut)) : Text.addCommas((long)maxIn) + "/" + Text.addCommas((long)maxOut))});
        return lines;
    }

    public PowahBlock getBlock() {
        return this.block;
    }
}

