/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import owmii.lib.util.Player;
import owmii.lib.util.Text;
import owmii.lib.util.math.V3d;
import owmii.powah.block.PowahBlock;
import owmii.powah.block.generator.GeneratorBlock;
import owmii.powah.client.renderer.tile.ReactorRenderer;
import owmii.powah.item.PowahBlockItem;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ReactorItem
extends PowahBlockItem {
    static final ResourceLocation OV_TEXTURE = new ResourceLocation("powah", "textures/misc/reactor_ov.png");

    public ReactorItem(PowahBlock block, Item.Properties properties, @Nullable ItemGroup group) {
        super(block, properties, group);
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        if (!context.func_196011_b()) {
            return ActionResultType.FAIL;
        }
        PlayerEntity player = context.func_195999_j();
        if (player == null || Player.isFake((PlayerEntity)player)) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = context.func_195996_i();
        if (stack.func_190916_E() < 36 && !player.func_184812_l_()) {
            player.func_146105_b(new TranslationTextComponent("chat.powah.not.enough.blocks", new Object[]{"" + TextFormatting.YELLOW + (36 - stack.func_190916_E()) + TextFormatting.RED}).func_211708_a(TextFormatting.RED), true);
            return ActionResultType.FAIL;
        }
        BlockPos pos = context.func_195995_a();
        List list = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 3, 1)).map(BlockPos::func_185334_h).collect(Collectors.toList());
        for (BlockPos blockPos : list) {
            if (context.func_195991_k().func_180495_p(blockPos).func_185904_a().func_76222_j()) continue;
            return ActionResultType.FAIL;
        }
        List entities = context.func_195991_k().func_217357_a(LivingEntity.class, new AxisAlignedBB(pos).func_72314_b(1.0, 3.0, 1.0));
        if (!entities.isEmpty()) {
            return ActionResultType.FAIL;
        }
        stack.func_190918_g(35);
        return super.func_195942_a(context);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderOv(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        boolean flag = false;
        boolean flag1 = false;
        for (Hand hand : Hand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (!(stack.func_77973_b() instanceof ReactorItem)) continue;
            flag = true;
            if (stack.func_190916_E() < 36) break;
            flag1 = true;
            break;
        }
        if (!flag) {
            return;
        }
        RayTraceResult result = mc.field_71476_x;
        if (result instanceof BlockRayTraceResult) {
            boolean isReplaceable;
            BlockRayTraceResult br = (BlockRayTraceResult)result;
            boolean bl = isReplaceable = mc.field_71441_e.func_180495_p(br.func_216350_a()).func_185904_a().func_76222_j() && !mc.field_71441_e.func_175623_d(br.func_216350_a());
            if (mc.field_71441_e.func_175623_d(br.func_216350_a()) || !isReplaceable && !br.func_216354_b().equals((Object)Direction.UP)) {
                return;
            }
            ActiveRenderInfo renderInfo = mc.field_71460_t.func_215316_n();
            double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            BlockPos pos = isReplaceable ? br.func_216350_a() : br.func_216350_a().func_177972_a(br.func_216354_b());
            V3d v3d = V3d.from((Vec3i)pos).centerD().down().down(0.6);
            List list = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 3, 1)).map(BlockPos::func_185334_h).collect(Collectors.toList());
            int color = 7725206;
            if (!flag1 && !player.func_184812_l_()) {
                color = 13566990;
            }
            if (color != 13566990) {
                List entities;
                for (BlockPos blockPos : list) {
                    if (mc.field_71441_e.func_180495_p(blockPos).func_185904_a().func_76222_j()) continue;
                    color = 13566990;
                    break;
                }
                if (!(entities = mc.field_71441_e.func_217357_a(LivingEntity.class, new AxisAlignedBB(pos).func_72314_b(1.0, 3.0, 1.0))).isEmpty()) {
                    color = 13566990;
                }
            }
            GlStateManager.pushMatrix();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            double offset = mc.field_71441_e.func_180495_p(pos).func_185904_a().func_76222_j() ? 0.0 : 0.0;
            GlStateManager.translated((double)(-x), (double)(-y), (double)(-z));
            GlStateManager.translated((double)v3d.field_72450_a, (double)(v3d.field_72448_b + offset), (double)v3d.field_72449_c);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GlStateManager.color4f((float)r, (float)g, (float)b, (float)0.6f);
            int j3 = 0xA000A0;
            int k3 = j3 >> 16 & 0xFFFF;
            int l3 = j3 & 0xFFFF;
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)k3, (float)l3);
            mc.func_110434_K().func_110577_a(OV_TEXTURE);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            double dim = 1.5;
            buffer.func_181662_b(dim, 0.0, dim).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(dim, 0.0, -dim).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(-dim, 0.0, -dim).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(-dim, 0.0, dim).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.disableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.popMatrix();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<String, Object[]> getBookInfo(ItemStack stack, Map<String, Object[]> lines) {
        if (this.getBlock().getCapacity() > 0) {
            lines.put("info.powah.capacity", new Object[]{Text.addCommas((long)this.getBlock().getCapacity())});
        }
        if (this.getBlock() instanceof GeneratorBlock) {
            lines.put("info.powah.generation.factor", new Object[]{Text.addCommas((long)((GeneratorBlock)this.getBlock()).perTick())});
        }
        int maxIn = this.getBlock().getMaxReceive();
        int maxOut = this.getBlock().getMaxExtract();
        lines.put("info.powah.max.io", new Object[]{maxIn == maxOut ? Text.addCommas((long)maxOut) : (maxIn == 0 || maxOut == 0 ? Text.addCommas((long)Math.max(maxIn, maxOut)) : Text.addCommas((long)maxIn) + "/" + Text.addCommas((long)maxOut))});
        return lines;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderByItem(ItemStack stack) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("powah", "textures/ter/reactor_block" + Objects.requireNonNull(this.getRegistryName()).func_110623_a().substring(7) + ".png"));
        ReactorRenderer.CUBE_MODEL.render();
        GlStateManager.popMatrix();
    }
}

