/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.network.packet;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import owmii.lib.network.IPacket;
import owmii.lib.util.Server;
import owmii.powah.block.PowahTile;

public class NextPowerMode
implements IPacket<NextPowerMode> {
    private int i;
    private int dim;
    private BlockPos pos;

    public NextPowerMode(int i, int dim, BlockPos pos) {
        this.i = i;
        this.dim = dim;
        this.pos = pos;
    }

    public NextPowerMode() {
        this(0, 0, BlockPos.field_177992_a);
    }

    public void encode(NextPowerMode msg, PacketBuffer buffer) {
        buffer.writeInt(msg.i);
        buffer.writeInt(msg.dim);
        buffer.func_179255_a(msg.pos);
    }

    public NextPowerMode decode(PacketBuffer buffer) {
        return new NextPowerMode(buffer.readInt(), buffer.readInt(), buffer.func_179259_c());
    }

    public void handle(NextPowerMode msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Optional world = Server.getWorld((int)msg.dim);
            world.ifPresent(serverWorld -> {
                TileEntity tileEntity = serverWorld.func_175625_s(msg.pos);
                if (tileEntity instanceof PowahTile) {
                    if (msg.i == 6) {
                        ((PowahTile)tileEntity).getSideConfig().nextPowerModeAllSides();
                    } else {
                        ((PowahTile)tileEntity).getSideConfig().nextPowerMode(Direction.func_82600_a((int)msg.i));
                    }
                    ((PowahTile)tileEntity).markDirtyAndSync();
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

