/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.network.packet;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import owmii.lib.network.IPacket;
import owmii.lib.util.Server;
import owmii.powah.block.endercell.EnderCellTile;

public class SetActiveChannel
implements IPacket<SetActiveChannel> {
    private int activeChannel;
    private int dim;
    private BlockPos pos;

    public SetActiveChannel(int activeChannel, int dim, BlockPos pos) {
        this.activeChannel = activeChannel;
        this.dim = dim;
        this.pos = pos;
    }

    public SetActiveChannel() {
        this(0, 0, BlockPos.field_177992_a);
    }

    public void encode(SetActiveChannel msg, PacketBuffer buffer) {
        buffer.writeInt(msg.activeChannel);
        buffer.writeInt(msg.dim);
        buffer.func_179255_a(msg.pos);
    }

    public SetActiveChannel decode(PacketBuffer buffer) {
        return new SetActiveChannel(buffer.readInt(), buffer.readInt(), buffer.func_179259_c());
    }

    public void handle(SetActiveChannel msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Optional world = Server.getWorld((int)msg.dim);
            world.ifPresent(serverWorld -> {
                TileEntity tileEntity = serverWorld.func_175625_s(msg.pos);
                if (tileEntity instanceof EnderCellTile) {
                    ((EnderCellTile)tileEntity).setActiveChannel(msg.activeChannel);
                    ((EnderCellTile)tileEntity).markDirtyAndSync();
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

