/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.api;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class PowahAPI {
    public static final Map<Fluid, Integer> MAGMATIC_FLUIDS = new HashMap<Fluid, Integer>();
    public static final Map<Fluid, Integer> COOLANTS = new HashMap<Fluid, Integer>();
    public static final Map<ResourceLocation, Pair<Integer, Integer>> SOLID_COOLANTS = new HashMap<ResourceLocation, Pair<Integer, Integer>>();
    public static final Map<Block, Integer> HEAT_SOURCES = new HashMap<Block, Integer>();

    public static void registerMagmaticFluid(Fluid fluid, int heat) {
        MAGMATIC_FLUIDS.put(fluid, heat);
    }

    public static int getMagmaticFluidHeat(Fluid fluid) {
        if (MAGMATIC_FLUIDS.containsKey(fluid)) {
            return MAGMATIC_FLUIDS.get(fluid);
        }
        return 0;
    }

    public static void registerCoolant(Fluid fluid, int cooling) {
        COOLANTS.put(fluid, cooling);
    }

    public static int getCoolant(Fluid fluid) {
        if (COOLANTS.containsKey(fluid)) {
            return COOLANTS.get(fluid);
        }
        return 0;
    }

    public static void registerHeatSource(Block block, int heat) {
        HEAT_SOURCES.put(block, heat);
    }

    public static int getHeatSource(Block block) {
        if (HEAT_SOURCES.containsKey(block)) {
            return HEAT_SOURCES.get(block);
        }
        return 0;
    }

    public static void registerSolidCoolant(IItemProvider item, int size, int cooling) {
        SOLID_COOLANTS.put(item.func_199767_j().getRegistryName(), (Pair<Integer, Integer>)Pair.of((Object)size, (Object)cooling));
    }

    public static Pair<Integer, Integer> getSolidCoolant(IItemProvider item) {
        if (SOLID_COOLANTS.containsKey(item.func_199767_j().getRegistryName())) {
            return SOLID_COOLANTS.get(item.func_199767_j().getRegistryName());
        }
        return Pair.of((Object)0, (Object)0);
    }
}

