/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.block.TileBase;
import owmii.lib.energy.Energy;
import owmii.lib.util.IVariant;
import owmii.powah.block.ITiles;
import owmii.powah.block.Tier;
import owmii.powah.block.cable.EnergyCableBlock;
import owmii.powah.block.cable.EnergyProxy;

public class EnergyCableTile
extends TileBase.EnergyStorage<Tier, EnergyCableBlock> {
    public final Map<Direction, EnergyProxy> proxyMap = new HashMap<Direction, EnergyProxy>();
    public final Set<Direction> energySides = new HashSet<Direction>();

    public EnergyCableTile(Tier variant) {
        super(ITiles.ENERGY_CABLE, (IVariant)variant);
        for (Direction side : Direction.values()) {
            this.proxyMap.put(side, new EnergyProxy());
        }
    }

    public EnergyCableTile() {
        this(Tier.STARTER);
    }

    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        ListNBT list = compound.func_150295_c("LinkedCables", 10);
        IntStream.range(0, list.size()).mapToObj(arg_0 -> ((ListNBT)list).func_150305_b(arg_0)).forEach(nbt -> {
            Direction direction = Direction.values()[nbt.func_74762_e("Direction")];
            this.proxyMap.put(direction, new EnergyProxy().read((CompoundNBT)nbt));
        });
        ListNBT list1 = compound.func_150295_c("EnergyDirections", 10);
        IntStream.range(0, list1.size()).mapToObj(arg_0 -> ((ListNBT)list1).func_150305_b(arg_0)).map(nbt -> Direction.values()[nbt.func_74762_e("EnergyDirection")]).forEach(this.energySides::add);
    }

    public CompoundNBT writeSync(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        this.proxyMap.forEach((direction, linkedCables) -> {
            CompoundNBT nbt = new CompoundNBT();
            linkedCables.write(nbt);
            nbt.func_74768_a("Direction", direction.ordinal());
            list.add((Object)nbt);
        });
        compound.func_218657_a("LinkedCables", (INBT)list);
        ListNBT list1 = new ListNBT();
        this.energySides.forEach(direction -> {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("EnergyDirection", direction.ordinal());
            list1.add((Object)nbt);
        });
        compound.func_218657_a("EnergyDirections", (INBT)list1);
        return super.writeSync(compound);
    }

    public long receiveEnergy(int maxReceive, boolean simulate, @Nullable Direction direction) {
        if (this.field_145850_b == null || this.isRemote() || direction == null || !this.canReceiveEnergy(direction)) {
            return 0L;
        }
        long received = 0L;
        received += this.pushEnergy(maxReceive, simulate, direction, this);
        for (BlockPos cablePos : this.proxyMap.get(direction).cables()) {
            TileEntity cableTile = this.field_145850_b.func_175625_s(cablePos);
            if (!(cableTile instanceof EnergyCableTile)) continue;
            EnergyCableTile cable = (EnergyCableTile)cableTile;
            received += cable.pushEnergy(maxReceive, simulate, direction, this);
        }
        return received;
    }

    private long pushEnergy(int maxReceive, boolean simulate, @Nullable Direction direction, EnergyCableTile cable) {
        long received = 0L;
        for (Direction side : this.energySides) {
            if (((Object)((Object)cable)).equals((Object)this) && side.equals((Object)direction) || !this.canExtractEnergy(side)) continue;
            BlockPos pos = this.field_174879_c.func_177972_a(side);
            if (direction != null && cable.func_174877_v().func_177972_a(direction).equals((Object)pos)) continue;
            TileEntity tile = this.getTileEntity(pos);
            long amount = (long)maxReceive - received;
            if (amount <= 0L || !Energy.canReceive((TileEntity)tile, (Direction)side)) continue;
            long net = Math.min(amount, this.energy.getMaxExtract());
            amount -= net;
            if ((long)maxReceive - (received += (long)Energy.receive((TileEntity)tile, (Direction)side, (long)net, (boolean)simulate)) > 0L) continue;
            return received;
        }
        return received;
    }

    public void search(Block block, Direction side) {
        this.proxyMap.get(side).search(block, this, side).clear();
    }

    public long defaultEnergyCapacity() {
        return 0L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
    }

    public void getListedEnergyInfo(List<String> list) {
    }
}

