/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.tuple.Pair;
import owmii.lib.block.TileBase;
import owmii.lib.energy.Energy;
import owmii.lib.util.Data;
import owmii.lib.util.IVariant;
import owmii.lib.util.Ticker;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.ITiles;
import owmii.powah.block.Tier;
import owmii.powah.block.reactor.ReactorBlock;
import owmii.powah.block.reactor.ReactorPartTile;
import owmii.powah.item.IItems;

public class ReactorTile
extends TileBase.EnergyProvider<Tier, ReactorBlock> {
    protected final FluidTank tank = new FluidTank(1000){

        public boolean isFluidValid(FluidStack stack) {
            return PowahAPI.COOLANTS.containsKey(stack.getFluid()) && super.isFluidValid(stack);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            ReactorTile.this.sync(5);
        }
    };
    private final LazyOptional<IFluidHandler> holder;
    private List<BlockPos> posList = new ArrayList<BlockPos>();
    private boolean built;
    private final Ticker fuel = new Ticker(1000.0);
    private final Ticker carbon = Ticker.empty();
    private final Ticker redstone = Ticker.empty();
    private final Ticker solidCoolant = Ticker.empty();
    private int solidCoolantTemp;
    private final Ticker temp = new Ticker(1000.0);
    private int baseTemp;
    private int carbonTemp;
    private int redstoneTemp;
    private boolean running;
    private boolean genModeOn;
    private boolean generate = true;

    public ReactorTile(Tier variant) {
        super(ITiles.REACTOR, (IVariant)variant);
        this.holder = LazyOptional.of(() -> this.tank);
        this.inv.add(4);
    }

    public ReactorTile() {
        this(Tier.STARTER);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.posList = (List)Data.readPosList((CompoundNBT)compound, (String)"QueuedPos", new ArrayList());
        this.baseTemp = compound.func_74762_e("BaseTemp");
        this.carbonTemp = compound.func_74762_e("CarbonTemp");
        this.redstoneTemp = compound.func_74762_e("RedstoneTemp");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        Data.writePosList((CompoundNBT)compound, this.posList, (String)"QueuedPos");
        compound.func_74768_a("BaseTemp", this.baseTemp);
        compound.func_74768_a("CarbonTemp", this.carbonTemp);
        compound.func_74768_a("RedstoneTemp", this.redstoneTemp);
        return super.func_189515_b(compound);
    }

    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        this.tank.readFromNBT(compound);
        this.built = compound.func_74767_n("Built");
        this.fuel.read(compound, "Fuel");
        this.carbon.read(compound, "Carbon");
        this.redstone.read(compound, "Redstone");
        this.solidCoolant.read(compound, "SolidCoolant");
        this.solidCoolantTemp = compound.func_74762_e("SolidCoolantTemp");
        this.running = compound.func_74767_n("running");
        this.genModeOn = compound.func_74767_n("gen_mode");
        this.generate = compound.func_74767_n("generate");
        this.temp.read(compound, "Temperature");
    }

    public CompoundNBT writeSync(CompoundNBT compound) {
        this.tank.writeToNBT(compound);
        compound.func_74757_a("Built", this.built);
        this.fuel.write(compound, "Fuel");
        this.carbon.write(compound, "Carbon");
        this.redstone.write(compound, "Redstone");
        this.solidCoolant.write(compound, "SolidCoolant");
        compound.func_74768_a("SolidCoolantTemp", this.solidCoolantTemp);
        compound.func_74757_a("running", this.running);
        compound.func_74757_a("gen_mode", this.genModeOn);
        compound.func_74757_a("generate", this.generate);
        this.temp.write(compound, "Temperature");
        return super.writeSync(compound);
    }

    protected boolean postTicks(World world) {
        if (this.isRemote()) {
            return false;
        }
        boolean flag = false;
        boolean flag2 = false;
        int extracted = 0;
        if (this.built) {
            if (this.doWorkingTicks(world) && this.checkGenMode()) {
                boolean generating = !this.energy.isFull() && !this.fuel.isEmpty();
                boolean b0 = this.processFuel(world);
                boolean b1 = this.processCarbon(world, generating);
                boolean b2 = this.processRedstone(world, generating);
                boolean b3 = this.processTemperature(world, generating);
                if (b0 || b1 || b2 || b3) {
                    flag = true;
                }
                if (generating) {
                    this.fuel.back(this.calcConsumption());
                    this.energy.produce(this.getGeneration());
                    flag = true;
                    flag2 = true;
                }
                if (flag && this.isContainerOpen) {
                    this.sync(3);
                }
            }
            for (Direction direction : Direction.values()) {
                if (!this.canExtractEnergy(direction)) continue;
                long amount = Math.min(this.getMaxEnergyExtract(), this.getEnergyStored());
                BlockPos pos = this.field_174879_c.func_177967_a(direction, direction.func_176740_k().func_176722_c() ? 2 : (direction.equals((Object)Direction.UP) ? 4 : 1));
                int received = Energy.receive((TileEntity)this.getTileEntity(pos), (Direction)direction, (long)amount, (boolean)false);
                extracted = (int)((long)extracted + this.extractEnergy(received, false, direction));
            }
            if (this.running != flag2) {
                this.running = flag2;
                this.sync(5);
            }
        } else if (!this.build(world)) {
            return false;
        }
        return extracted > 0;
    }

    private boolean checkGenMode() {
        if (this.genModeOn) {
            if (this.energy.isFull()) {
                this.generate = false;
            } else if (this.energy.getPercent() <= 70L) {
                this.generate = true;
            }
            return this.generate;
        }
        return true;
    }

    public long getGeneration() {
        return (long)this.calcProduction();
    }

    public double calcProduction() {
        double d = this.carbon.isEmpty() ? 1.0 : 1.2;
        double d1 = this.redstone.isEmpty() ? 1.0 : 1.4;
        return (1.0 - this.calc()) * (this.fuel.getTicks() / 100.0) * (double)this.defaultGeneration() * d * d1;
    }

    public double calcConsumption() {
        double d1 = 1.0 + (double)((Tier)this.variant).ordinal() * 0.25;
        return (1.0 + (double)((Tier)this.variant).ordinal() * 0.25) * this.calc();
    }

    public double calc() {
        double d0 = this.redstone.isEmpty() ? 1.0 : 1.4;
        return this.temp.getTicks() / 1000.0 * 0.98 / 2.0 * d0;
    }

    private boolean processTemperature(World world, boolean generating) {
        ItemStack stack;
        boolean flag = false;
        if (this.solidCoolant.isEmpty() && !(stack = this.inv.getStackInSlot(3)).func_190926_b()) {
            Pair<Integer, Integer> coolant = PowahAPI.getSolidCoolant((IItemProvider)stack.func_77973_b());
            int size = (Integer)coolant.getLeft();
            int temp = (Integer)coolant.getRight();
            if (size > 0 && temp < 2) {
                this.solidCoolant.setAll((double)size);
                this.solidCoolantTemp = temp;
                stack.func_190918_g(1);
                flag = true;
            }
        }
        if (!this.solidCoolant.isEmpty()) {
            if (!this.tank.isEmpty() && generating && this.ticks % 40 == 0) {
                this.solidCoolant.back();
                if (this.solidCoolant.isEmpty()) {
                    this.solidCoolant.setMax(0.0);
                }
                flag = true;
            }
        } else {
            this.solidCoolantTemp = 0;
        }
        double temp = Math.min((double)(this.baseTemp + this.carbonTemp + this.redstoneTemp), this.temp.getMax());
        if (!this.tank.isEmpty()) {
            int coldness = PowahAPI.getCoolant(this.tank.getFluid().getFluid()) - 2;
            int i = Math.abs(coldness + this.solidCoolantTemp) + 1;
            temp /= (double)i;
            this.sync(5);
        }
        if (this.temp.getTicks() < temp) {
            this.temp.onward();
            flag = true;
        }
        if (this.ticks % (this.tank.isEmpty() ? 5 : (this.solidCoolant.isEmpty() ? 3 : 1)) == 0 && this.temp.getTicks() > temp) {
            this.temp.back();
            flag = true;
        }
        return flag;
    }

    private boolean processRedstone(World world, boolean generating) {
        boolean flag = false;
        if (this.redstone.isEmpty()) {
            ItemStack stack = this.inv.getStackInSlot(2);
            if (stack.func_77973_b() == Items.field_151137_ax) {
                this.redstone.setAll(18.0);
            } else if (stack.func_77973_b() == Items.field_221858_em) {
                this.redstone.setAll(162.0);
            }
            this.redstoneTemp = 120;
            stack.func_190918_g(1);
            flag = true;
        }
        if (!this.redstone.isEmpty()) {
            if (generating && this.ticks % 40 == 0) {
                this.redstone.back();
                if (this.redstone.isEmpty()) {
                    this.redstone.setMax(0.0);
                }
                flag = true;
            }
        } else {
            this.redstoneTemp = 0;
        }
        return flag;
    }

    private boolean processCarbon(World world, boolean generating) {
        int carbon;
        ItemStack stack;
        boolean flag = false;
        if (this.carbon.isEmpty() && !(stack = this.inv.getStackInSlot(1)).func_190926_b() && (carbon = ForgeHooks.getBurnTime((ItemStack)stack)) > 0) {
            this.carbon.setAll((double)carbon);
            this.carbonTemp = 180;
            stack.func_190918_g(1);
            flag = true;
        }
        if (!this.carbon.isEmpty()) {
            if (generating) {
                this.carbon.back();
                if (this.carbon.isEmpty()) {
                    this.carbon.setMax(0.0);
                }
            }
        } else {
            this.carbonTemp = 0;
        }
        return flag;
    }

    private boolean processFuel(World world) {
        ItemStack stack;
        boolean flag = false;
        if (this.fuel.getTicks() <= 900.0 && (stack = this.inv.getStackInSlot(0)).func_77973_b() == IItems.URANINITE) {
            this.fuel.add(100.0);
            this.baseTemp = 700;
            stack.func_190918_g(1);
            flag = true;
        }
        if (this.fuel.isEmpty()) {
            this.baseTemp = 0;
        }
        return flag;
    }

    private boolean build(World world) {
        if (!this.posList.isEmpty()) {
            boolean flag = true;
            for (BlockPos pos : this.posList) {
                if (world.func_180495_p(pos).func_185904_a().func_76222_j()) continue;
                flag = false;
                break;
            }
            if (flag && this.ticks > 4 && this.ticks % 5 == 0) {
                Iterator<BlockPos> itr = this.posList.iterator();
                while (itr.hasNext()) {
                    BlockPos pos;
                    pos = itr.next();
                    BlockState state = ((ReactorBlock)this.getBlock()).func_176223_P();
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)ReactorBlock.CORE, (Comparable)Boolean.valueOf(false)), 3);
                    TileEntity tileEntity = this.getTileEntity(pos);
                    if (!(tileEntity instanceof ReactorPartTile)) continue;
                    ReactorPartTile part = (ReactorPartTile)tileEntity;
                    part.setCorePos(this.field_174879_c);
                    world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)this.func_195044_w()));
                    itr.remove();
                    return false;
                }
            }
        } else {
            for (Direction side : Direction.values()) {
                if (side.equals((Object)Direction.DOWN)) continue;
                BlockPos pos = this.field_174879_c.func_177972_a(side).func_177981_b(side.equals((Object)Direction.UP) ? 2 : 0);
                TileEntity tileEntity = this.getTileEntity(pos);
                if (!(tileEntity instanceof ReactorPartTile)) continue;
                ReactorPartTile part = (ReactorPartTile)tileEntity;
                part.setExtractor(true);
            }
            for (BlockPos pos : this.getPosList()) {
                TileEntity tileEntity = this.getTileEntity(pos);
                if (!(tileEntity instanceof ReactorPartTile)) continue;
                ReactorPartTile part = (ReactorPartTile)tileEntity;
                part.setBuilt(true);
                part.markDirtyAndSync();
            }
            this.built = true;
            this.markDirtyAndSync();
        }
        return true;
    }

    public void demolish(World world) {
        List<BlockPos> list = this.getPosList();
        list.add(this.field_174879_c);
        for (int i = 0; i < list.size(); ++i) {
            BlockPos blockPos = list.get(i);
            if (!world.func_180495_p(blockPos).func_177230_c().equals(this.getBlock())) continue;
            Block.func_180635_a((World)world, (BlockPos)this.field_174879_c, (ItemStack)new ItemStack((IItemProvider)this.getBlock()));
            world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        this.posList.forEach(pos -> Block.func_180635_a((World)world, (BlockPos)this.field_174879_c, (ItemStack)new ItemStack((IItemProvider)this.getBlock())));
        while (this.fuel.getTicks() >= 100.0) {
            Block.func_180635_a((World)world, (BlockPos)this.field_174879_c, (ItemStack)new ItemStack((IItemProvider)IItems.URANINITE));
            this.fuel.back(100.0);
        }
        this.posList.clear();
        world.func_180501_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P(), 3);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void shuffle() {
        this.posList.addAll(this.getPosList());
        Collections.shuffle(this.posList);
    }

    public boolean isBuilt() {
        return this.built;
    }

    public Ticker getFuel() {
        return this.fuel;
    }

    public Ticker getCarbon() {
        return this.carbon;
    }

    public Ticker getRedstone() {
        return this.redstone;
    }

    public Ticker getSolidCoolant() {
        return this.solidCoolant;
    }

    public int getSolidCoolantTemp() {
        return this.solidCoolantTemp;
    }

    public Ticker getTemp() {
        return this.temp;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isGenModeOn() {
        return this.genModeOn;
    }

    public void setGenModeOn(boolean genModeOn) {
        this.genModeOn = genModeOn;
        this.markDirtyAndSync();
    }

    public List<BlockPos> getPosList() {
        return BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(-1, 0, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 3, 1)).map(BlockPos::func_185334_h).filter(pos1 -> !pos1.equals((Object)this.field_174879_c)).collect(Collectors.toList());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72314_b(1.0, 3.0, 1.0);
    }

    public boolean canInsert(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() == IItems.URANINITE;
        }
        if (index == 1) {
            return ForgeHooks.getBurnTime((ItemStack)stack) > 0 && !stack.hasContainerItem();
        }
        if (index == 2) {
            return stack.func_77973_b() == Items.field_151137_ax || stack.func_77973_b() == Items.field_221858_em;
        }
        if (index == 3) {
            Pair<Integer, Integer> coolant = PowahAPI.getSolidCoolant((IItemProvider)stack.func_77973_b());
            return (Integer)coolant.getLeft() > 0 && (Integer)coolant.getRight() < 2;
        }
        return super.canInsert(index, stack);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }
}

