/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.block.AbstractEnergyStorage;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.logistics.energy.Energy;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.cable.CableBlock;
import owmii.powah.block.cable.EnergyProxy;
import owmii.powah.config.CableConfig;

public class CableTile
extends AbstractEnergyStorage<Tier, CableConfig, CableBlock>
implements IInventoryHolder {
    public final Map<Direction, EnergyProxy> proxyMap = new HashMap<Direction, EnergyProxy>();
    public final Set<Direction> energySides = new HashSet<Direction>();

    public CableTile(Tier variant) {
        super(Tiles.CABLE, (Enum)variant);
        for (Direction side : Direction.values()) {
            this.proxyMap.put(side, new EnergyProxy());
        }
    }

    public CableTile() {
        this(Tier.STARTER);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        this.proxyMap.forEach((direction, linkedCables) -> {
            CompoundNBT nbt = new CompoundNBT();
            linkedCables.write(nbt);
            nbt.func_74768_a("direction", direction.ordinal());
            list.add((Object)nbt);
        });
        compound.func_218657_a("linked_cables", (INBT)list);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        ListNBT list = compound.func_150295_c("linked_cables", 10);
        IntStream.range(0, list.size()).mapToObj(arg_0 -> ((ListNBT)list).func_150305_b(arg_0)).forEach(nbt -> {
            Direction direction = Direction.values()[nbt.func_74762_e("direction")];
            this.proxyMap.put(direction, new EnergyProxy().read((CompoundNBT)nbt));
        });
    }

    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        ListNBT list1 = compound.func_150295_c("energy_directions", 10);
        IntStream.range(0, list1.size()).mapToObj(arg_0 -> ((ListNBT)list1).func_150305_b(arg_0)).map(nbt -> Direction.values()[nbt.func_74762_e("energy_direction")]).forEach(this.energySides::add);
    }

    public CompoundNBT writeSync(CompoundNBT compound) {
        ListNBT list1 = new ListNBT();
        this.energySides.forEach(direction -> {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("energy_direction", direction.ordinal());
            list1.add((Object)nbt);
        });
        compound.func_218657_a("energy_directions", (INBT)list1);
        return super.writeSync(compound);
    }

    public long receiveEnergy(int maxReceive, boolean simulate, @Nullable Direction direction) {
        if (this.field_145850_b == null || this.isRemote() || direction == null || !this.checkRedstone() || !this.canReceiveEnergy(direction)) {
            return 0L;
        }
        long received = 0L;
        received += this.pushEnergy(this.field_145850_b, maxReceive, simulate, direction, this);
        for (BlockPos cablePos : this.proxyMap.get(direction).cables()) {
            long amount = (long)maxReceive - received;
            if (amount <= 0L) break;
            TileEntity cableTile = this.field_145850_b.func_175625_s(cablePos);
            if (!(cableTile instanceof CableTile)) continue;
            CableTile cable = (CableTile)cableTile;
            received += cable.pushEnergy(this.field_145850_b, amount, simulate, direction, this);
        }
        return received;
    }

    private long pushEnergy(World world, long maxReceive, boolean simulate, @Nullable Direction direction, CableTile cable) {
        long received = 0L;
        for (Direction side : this.energySides) {
            TileEntity tile;
            long amount = Math.min(maxReceive - received, this.energy.getMaxExtract());
            if (amount <= 0L) break;
            if (((Object)((Object)cable)).equals((Object)this) && side.equals((Object)direction) || !this.canExtractEnergy(side)) continue;
            BlockPos pos = this.field_174879_c.func_177972_a(side);
            if (direction != null && cable.func_174877_v().func_177972_a(direction).equals((Object)pos) || !Energy.canReceive((TileEntity)(tile = world.func_175625_s(pos)), (Direction)side)) continue;
            received += (long)Energy.receive((TileEntity)tile, (Direction)side, (long)amount, (boolean)simulate);
        }
        return received;
    }

    public void search(Block block, Direction side) {
        this.proxyMap.get(side).search(block, this, side).clear();
    }

    protected long getEnergyCapacity() {
        return 0L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
    }

    public int getSlotLimit(int slot) {
        return 0;
    }

    public boolean canInsert(int slot, ItemStack stack) {
        return false;
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return false;
    }

    public boolean keepStorable() {
        return false;
    }
}

