/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import owmii.powah.block.cable.CableBlock;
import owmii.powah.block.cable.CableTile;

public class EnergyProxy {
    public final Map<Direction, EnergyProxy> proxies = new HashMap<Direction, EnergyProxy>();
    public final List<BlockPos> searchCache = new ArrayList<BlockPos>();
    public final List<BlockPos> cables = new ArrayList<BlockPos>();

    public void init() {
        for (Direction side : Direction.values()) {
            this.proxies.put(side, new EnergyProxy());
        }
    }

    public EnergyProxy read(CompoundNBT compound) {
        ListNBT listNBT = compound.func_150295_c("cables_pos", 10);
        for (int j = 0; j < listNBT.size(); ++j) {
            CompoundNBT nbt = listNBT.func_150305_b(j);
            this.add(NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("cable_pos")));
        }
        return this;
    }

    public CompoundNBT write(CompoundNBT compound) {
        ListNBT listNBT = new ListNBT();
        this.cables.forEach(pos -> {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("cable_pos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
            listNBT.add((Object)nbt);
        });
        compound.func_218657_a("cables_pos", (INBT)listNBT);
        return compound;
    }

    public Set<CableTile> all(World world) {
        HashSet<CableTile> cableTiles = new HashSet<CableTile>();
        Iterator<BlockPos> iterator = this.cables.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof CableTile) {
                cableTiles.add((CableTile)tileEntity);
                continue;
            }
            iterator.remove();
        }
        return cableTiles;
    }

    public List<BlockPos> search(Block block, CableTile tile, Direction side) {
        World world = tile.func_145831_w();
        if (world != null) {
            BlockPos pos = tile.func_174877_v();
            this.searchCache.add(pos);
            for (Direction direction : Direction.values()) {
                BlockPos blockPos = pos.func_177972_a(direction);
                BlockState state = world.func_180495_p(blockPos);
                if (state.func_177230_c() != block) continue;
                TileEntity tile1 = world.func_175625_s(blockPos);
                if (tile1 instanceof CableTile) {
                    this.add(blockPos);
                }
                CableBlock cableBlock = (CableBlock)state.func_177230_c();
                cableBlock.searchCables((IWorld)world, blockPos, tile, side);
            }
        }
        return this.searchCache;
    }

    public boolean remove(BlockPos pos) {
        return this.cables.remove(pos);
    }

    public boolean add(BlockPos pos) {
        if (!this.cables.contains(pos)) {
            return this.cables.add(pos);
        }
        return false;
    }

    public List<BlockPos> cables() {
        return this.cables;
    }
}

