/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.ender;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import owmii.lib.block.AbstractBlock;
import owmii.lib.block.AbstractEnergyBlock;
import owmii.lib.block.AbstractTileEntity;
import owmii.lib.item.EnergyBlockItem;
import owmii.lib.logistics.inventory.AbstractContainer;
import owmii.powah.block.Tier;
import owmii.powah.block.ender.EnderGateTile;
import owmii.powah.config.Configs;
import owmii.powah.config.EnderGateConfig;
import owmii.powah.inventory.EnderCellContainer;

public class EnderGateBlock
extends AbstractEnergyBlock<Tier, EnderGateConfig, EnderGateBlock> {
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    public EnderGateBlock(AbstractBlock.Properties properties, Tier variant) {
        super(properties, (Enum)variant);
    }

    public EnderGateConfig getConfig() {
        return Configs.ENDER_GATE;
    }

    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable ItemGroup group) {
        return super.getBlockItem(properties.func_200917_a(1), group);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((Property)BlockStateProperties.field_208155_H));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnderGateTile((Tier)this.variant);
    }

    @Nullable
    public AbstractContainer getContainer(int id, PlayerInventory inventory, AbstractTileEntity te, BlockRayTraceResult result) {
        if (te instanceof EnderGateTile) {
            return new EnderCellContainer(id, inventory, (EnderGateTile)te);
        }
        return null;
    }

    protected boolean checkValidEnergySide() {
        return true;
    }

    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.ALL;
    }

    static {
        SHAPES.put(Direction.UP, EnderGateBlock.func_208617_a((double)6.0, (double)15.5, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
        SHAPES.put(Direction.DOWN, EnderGateBlock.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)0.5, (double)10.0));
        SHAPES.put(Direction.NORTH, EnderGateBlock.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)0.5));
        SHAPES.put(Direction.SOUTH, EnderGateBlock.func_208617_a((double)6.0, (double)6.0, (double)15.5, (double)10.0, (double)10.0, (double)16.0));
        SHAPES.put(Direction.EAST, EnderGateBlock.func_208617_a((double)15.5, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
        SHAPES.put(Direction.WEST, EnderGateBlock.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)0.5, (double)10.0, (double)10.0));
    }
}

