/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.ender;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.storage.WorldSavedData;
import owmii.lib.block.IOwnable;
import owmii.lib.logistics.energy.Energy;

public class EnderNetwork
extends WorldSavedData {
    public static final EnderNetwork INSTANCE = new EnderNetwork();
    public static final int MAX_CHANNELS = 12;
    private final Map<UUID, ImmutableList<Energy>> map = new HashMap<UUID, ImmutableList<Energy>>();

    public EnderNetwork() {
        super("powah_network");
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT listNBT = nbt.func_150295_c("network", 10);
        this.map.clear();
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundNBT nbt1 = listNBT.func_150305_b(i);
            UUID uuid = nbt1.func_186857_a("owner_id");
            ListNBT listNBT1 = nbt1.func_150295_c("channels", 10);
            for (int j = 0; j < listNBT1.size(); ++j) {
                CompoundNBT nbt2 = listNBT1.func_150305_b(j);
                this.getEnergy(uuid, j).read(nbt2, true, false);
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        ListNBT listNBT = new ListNBT();
        this.map.forEach((uuid, list) -> {
            CompoundNBT nbt1 = new CompoundNBT();
            nbt1.func_186854_a("owner_id", uuid);
            ListNBT listNBT1 = new ListNBT();
            list.forEach(storage -> {
                CompoundNBT nbt2 = new CompoundNBT();
                storage.write(nbt2, true, false);
                listNBT1.add((Object)nbt2);
            });
            nbt1.func_218657_a("channels", (INBT)listNBT1);
            listNBT.add((Object)nbt1);
        });
        nbt.func_218657_a("network", (INBT)listNBT);
        return nbt;
    }

    public CompoundNBT serialize(UUID uuid) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("channels", (INBT)this.getChannels(uuid).stream().map(energy -> energy.write(true, false)).collect(Collectors.toCollection(ListNBT::new)));
        return nbt;
    }

    public void deserialize(UUID uuid, CompoundNBT nbt) {
        ListNBT listNBT = nbt.func_150295_c("channels", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            this.getEnergy(uuid, i).read(listNBT.func_150305_b(i), true, false);
        }
    }

    public Energy getEnergy(IOwnable ownable, int channel) {
        if (ownable.getOwner() != null) {
            return this.getEnergy(ownable.getOwner().getId(), channel);
        }
        return Energy.create((long)0L);
    }

    public Energy getEnergy(UUID uuid, int channel) {
        if (channel < 12) {
            return (Energy)this.getChannels(uuid).get(channel);
        }
        return Energy.create((long)0L);
    }

    public void setEnergy(UUID uuid, int channel, Energy energy) {
        this.getEnergy(uuid, channel).clone(energy);
        this.func_76185_a();
    }

    public ImmutableList<Energy> getChannels(IOwnable ownable) {
        if (ownable.getOwner() != null) {
            return this.getChannels(ownable.getOwner().getId());
        }
        return EnderNetwork.empty();
    }

    public ImmutableList<Energy> getChannels(UUID uuid) {
        return this.map.computeIfAbsent(uuid, k -> EnderNetwork.empty());
    }

    public static ImmutableList<Energy> empty() {
        return (ImmutableList)IntStream.range(0, 12).mapToObj(i -> Energy.create((long)0L)).collect(ImmutableList.toImmutableList());
    }
}

