/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import owmii.lib.block.AbstractBlock;
import owmii.lib.block.AbstractEnergyBlock;
import owmii.lib.client.handler.IHud;
import owmii.lib.client.util.Draw;
import owmii.lib.item.EnergyBlockItem;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.util.Util;
import owmii.lib.util.math.V3d;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.Tier;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.config.Configs;
import owmii.powah.config.EnergizingConfig;
import owmii.powah.item.WrenchItem;

public class EnergizingRodBlock
extends AbstractEnergyBlock<Tier, EnergizingConfig, EnergizingRodBlock>
implements IWaterLoggable,
IWrenchable,
IHud {
    public EnergizingRodBlock(AbstractBlock.Properties properties, Tier variant) {
        super(properties, (Enum)variant);
        this.setStateProps(state -> (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN));
        this.shapes.put(Direction.UP, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)7.25, (double)9.0, (double)7.25, (double)8.75, (double)13.0, (double)8.75), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        this.shapes.put(Direction.DOWN, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)7.25, (double)3.0, (double)7.25, (double)8.75, (double)7.0, (double)8.75), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        this.shapes.put(Direction.NORTH, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)3.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)7.25, (double)7.25, (double)3.0, (double)8.75, (double)8.75, (double)7.0), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        this.shapes.put(Direction.SOUTH, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)13.0, (double)9.0, (double)9.0, (double)16.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)7.25, (double)7.25, (double)13.0, (double)8.75, (double)8.75, (double)9.0), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        this.shapes.put(Direction.WEST, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)3.0, (double)9.0, (double)9.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)3.0, (double)7.25, (double)7.25, (double)7.0, (double)8.75, (double)8.75), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        this.shapes.put(Direction.EAST, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)13.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)13.0, (double)7.25, (double)7.25, (double)9.0, (double)8.75, (double)8.75), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
    }

    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable ItemGroup group) {
        return super.getBlockItem(properties.func_200917_a(1), group);
    }

    public EnergizingConfig getConfig() {
        return Configs.ENERGIZING;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnergizingRodTile((Tier)this.variant);
    }

    protected boolean checkValidEnergySide() {
        return true;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof EnergizingRodTile) {
            this.setOrbPos(worldIn, pos, (EnergizingRodTile)tileEntity);
        }
    }

    public void setOrbPos(World worldIn, BlockPos pos, EnergizingRodTile tile) {
        int range = (Integer)Configs.ENERGIZING.range.get();
        List list = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range)).map(BlockPos::func_185334_h).collect(Collectors.toList());
        for (BlockPos pos1 : list) {
            TileEntity tileEntity1;
            if (pos1.equals((Object)BlockPos.field_177992_a) || !((tileEntity1 = worldIn.func_175625_s(pos1)) instanceof EnergizingOrbTile)) continue;
            tile.setOrbPos(pos1);
            break;
        }
    }

    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.ALL;
    }

    @Override
    public boolean onWrench(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, Direction side, WrenchMode mode, Vector3d hit) {
        ItemStack stack;
        if (mode.link() && (stack = player.func_184586_b(hand)).func_77973_b() instanceof WrenchItem) {
            WrenchItem wrench = (WrenchItem)stack.func_77973_b();
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof EnergizingRodTile) {
                EnergizingRodTile rod = (EnergizingRodTile)tileEntity;
                CompoundNBT nbt = wrench.getWrenchNBT(stack);
                if (nbt.func_150297_b("OrbPos", 10)) {
                    BlockPos orbPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("OrbPos"));
                    TileEntity tileEntity1 = world.func_175625_s(orbPos);
                    if (tileEntity1 instanceof EnergizingOrbTile) {
                        EnergizingOrbTile orb = (EnergizingOrbTile)tileEntity1;
                        V3d v3d = V3d.from((BlockPos)orbPos);
                        if ((int)v3d.distance(pos) <= (Integer)Configs.ENERGIZING.range.get()) {
                            rod.setOrbPos(orbPos);
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.powah.wrench.link.done").func_240699_a_(TextFormatting.GOLD), true);
                        } else {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.powah.wrench.link.fail").func_240699_a_(TextFormatting.RED), true);
                        }
                    }
                    nbt.func_82580_o("OrbPos");
                } else {
                    nbt.func_218657_a("RodPos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.powah.wrench.link.start").func_240699_a_(TextFormatting.YELLOW), true);
                }
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderHud(MatrixStack matrix, BlockState state, World world, BlockPos pos, PlayerEntity player, BlockRayTraceResult result, @Nullable TileEntity te) {
        if (te instanceof EnergizingRodTile) {
            EnergizingRodTile rod = (EnergizingRodTile)te;
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer font = mc.field_71466_p;
            int x = mc.func_228018_at_().func_198107_o() / 2;
            int y = mc.func_228018_at_().func_198087_p();
            String s = TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.stored", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas((long)rod.getEnergy().getEnergyStored()), Util.numFormat((long)rod.getEnergy().getCapacity())});
            mc.func_110434_K().func_110577_a(new ResourceLocation("lollipop", "textures/gui/ov_energy.png"));
            GuiUtils.drawTexturedModalRect((int)(x - 37 - 1), (int)(y - 80), (int)0, (int)0, (int)74, (int)9, (float)0.0f);
            Draw.gaugeH((int)(x - 37), (int)(y - 79), (int)72, (int)16, (int)0, (int)9, (Energy)((EnergizingRodTile)te).getEnergy());
            font.func_238405_a_(matrix, s, (float)x - (float)font.func_78256_a(s) / 2.0f, (float)(y - 67), 0xFFFFFF);
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
        }
        return true;
    }
}

