/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import owmii.lib.block.AbstractEnergyStorage;
import owmii.lib.util.NBT;
import owmii.lib.util.Ticker;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodBlock;
import owmii.powah.config.Configs;
import owmii.powah.config.EnergizingConfig;

public class EnergizingRodTile
extends AbstractEnergyStorage<Tier, EnergizingConfig, EnergizingRodBlock> {
    private BlockPos orbPos = BlockPos.field_177992_a;
    public final Ticker coolDown = new Ticker(20.0);

    public EnergizingRodTile(Tier variant) {
        super(Tiles.ENERGIZING_ROD, (Enum)variant);
    }

    public EnergizingRodTile() {
        this(Tier.STARTER);
    }

    public void readSync(CompoundNBT nbt) {
        super.readSync(nbt);
        this.orbPos = NBT.readPos((CompoundNBT)nbt, (String)"OrbPos");
    }

    public CompoundNBT writeSync(CompoundNBT nbt) {
        NBT.writePos((CompoundNBT)nbt, (BlockPos)this.orbPos, (String)"OrbPos");
        return super.writeSync(nbt);
    }

    protected int postTick(World world) {
        TileEntity tileEntity;
        boolean flag = false;
        if (!this.orbPos.equals((Object)BlockPos.field_177992_a) && (tileEntity = world.func_175625_s(this.orbPos)) instanceof EnergizingOrbTile) {
            EnergizingOrbTile orb = (EnergizingOrbTile)tileEntity;
            if (orb.containRecipe() && this.energy.hasEnergy()) {
                this.coolDown.onward();
                flag = true;
            } else if (this.coolDown.getTicks() > 0.0) {
                this.coolDown.back();
                flag = true;
            }
            if (this.coolDown.ended()) {
                long fill = Math.min((long)this.energy.getEnergyStored(), ((EnergizingRodBlock)this.getBlock()).getConfig().getTransfer((Tier)this.getVariant()));
                this.energy.consume(orb.fillEnergy(fill));
                flag = true;
            }
        }
        return flag ? 10 : -1;
    }

    public boolean hasOrb() {
        if (this.field_145850_b == null) {
            return false;
        }
        return this.orbPos != BlockPos.field_177992_a && this.field_145850_b.func_175625_s(this.orbPos) instanceof EnergizingOrbTile;
    }

    public BlockPos getOrbPos() {
        return this.orbPos;
    }

    public void setOrbPos(BlockPos orbPos) {
        this.orbPos = orbPos;
        this.sync(2);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int range = (Integer)Configs.ENERGIZING.range.get();
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g((double)range);
    }

    public boolean keepEnergy() {
        return true;
    }

    public boolean isEnergyPresent(@Nullable Direction side) {
        return side != null && side.equals((Object)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H));
    }
}

