/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energycell;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import owmii.lib.block.AbstractEnergyStorage;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.logistics.Transfer;
import owmii.lib.logistics.energy.Energy;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.energycell.EnergyCellBlock;
import owmii.powah.config.EnergyCellConfig;

public class EnergyCellTile
extends AbstractEnergyStorage<Tier, EnergyCellConfig, EnergyCellBlock>
implements IInventoryHolder {
    public EnergyCellTile(Tier tier) {
        super(Tiles.ENERGY_CELL, (Enum)tier);
        this.inv.add(2);
    }

    public EnergyCellTile() {
        this(Tier.STARTER);
    }

    protected void onFirstTick(World world) {
        super.onFirstTick(world);
        if (this.isCreative()) {
            this.energy.setStored(this.getEnergyCapacity());
        }
    }

    protected int postTick(World world) {
        return this.chargeItems(2) + this.extractFromSides(world) > 0L ? 10 : -1;
    }

    public long extractEnergy(int maxExtract, boolean simulate, @Nullable Direction side) {
        return super.extractEnergy(maxExtract, simulate || this.isCreative(), side);
    }

    protected long receiveEnergy(int maxReceive, boolean simulate, @Nullable Direction side) {
        return super.receiveEnergy(maxReceive, simulate, side);
    }

    public boolean canExtractEnergy(@Nullable Direction side) {
        return this.checkRedstone() && super.canExtractEnergy(side);
    }

    public boolean canReceiveEnergy(@Nullable Direction side) {
        return this.checkRedstone() && super.canReceiveEnergy(side);
    }

    public boolean keepEnergy() {
        return !this.isCreative();
    }

    public Transfer getTransferType() {
        return this.isCreative() ? Transfer.EXTRACT : super.getTransferType();
    }

    public boolean isCreative() {
        return ((Tier)this.getVariant()).equals((Object)Tier.CREATIVE);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean canInsert(int slot, ItemStack stack) {
        return Energy.chargeable((ItemStack)stack);
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }
}

