/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.furnator;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import owmii.lib.block.AbstractEnergyProvider;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.util.Ticker;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.furnator.FurnatorBlock;
import owmii.powah.config.Configs;
import owmii.powah.config.generator.FurnatorConfig;

public class FurnatorTile
extends AbstractEnergyProvider<Tier, FurnatorConfig, FurnatorBlock>
implements IInventoryHolder {
    protected final Ticker carbon = Ticker.empty();
    protected boolean burning;

    public FurnatorTile(Tier variant) {
        super(Tiles.FURNATOR, (Enum)variant);
        this.inv.set(2);
    }

    public FurnatorTile() {
        this(Tier.STARTER);
    }

    public void readStorable(CompoundNBT nbt) {
        super.readStorable(nbt);
        this.carbon.read(nbt, "carbon");
    }

    public CompoundNBT writeStorable(CompoundNBT nbt) {
        this.carbon.write(nbt, "carbon");
        return super.writeStorable(nbt);
    }

    public void readSync(CompoundNBT nbt) {
        super.readSync(nbt);
        this.burning = nbt.func_74767_n("burning");
    }

    public CompoundNBT writeSync(CompoundNBT nbt) {
        nbt.func_74757_a("burning", this.burning);
        return super.writeSync(nbt);
    }

    protected int postTick(World world) {
        if (!this.isRemote() && this.checkRedstone()) {
            int burnTime;
            ItemStack stack;
            boolean flag = false;
            if (this.carbon.isEmpty() && !(stack = this.inv.getStackInSlot(1)).func_190926_b() && (burnTime = ForgeHooks.getBurnTime((ItemStack)stack)) > 0) {
                long perFuelTick = (Long)Configs.GENERAL.fuelTicks.get();
                this.carbon.setAll((double)((long)burnTime * perFuelTick));
                if (stack.hasContainerItem()) {
                    this.inv.setStackInSlot(1, stack.getContainerItem());
                } else {
                    stack.func_190918_g(1);
                }
                this.sync(4);
            }
            if (!this.carbon.isEmpty() && !this.energy.isFull()) {
                long toProduce = Math.min(this.energy.getEmpty(), Math.min(this.getGeneration(), (long)this.carbon.getTicks()));
                this.energy.produce(toProduce);
                this.carbon.back((double)toProduce);
                if (this.carbon.isEmpty()) {
                    this.carbon.setAll(0.0);
                }
                flag = true;
                this.sync(4);
            }
            if (this.burning != flag) {
                this.burning = flag;
                this.sync(4);
            }
        }
        return this.chargeItems(1) + this.extractFromSides(world) > 0L ? 10 : -1;
    }

    public boolean keepEnergy() {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean canInsert(int index, ItemStack stack) {
        return index == 1 && ForgeHooks.getBurnTime((ItemStack)stack) > 0 || index == 0 && Energy.chargeable((ItemStack)stack);
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }

    public Ticker getCarbon() {
        return this.carbon;
    }

    public boolean isBurning() {
        return this.burning;
    }
}

