/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.solar;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SixWayBlock;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import owmii.lib.block.AbstractGeneratorBlock;
import owmii.lib.block.AbstractTileEntity;
import owmii.lib.item.EnergyBlockItem;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.logistics.inventory.AbstractContainer;
import owmii.powah.block.Tier;
import owmii.powah.block.solar.SolarTile;
import owmii.powah.config.Configs;
import owmii.powah.config.generator.SolarConfig;
import owmii.powah.inventory.SolarContainer;

public class SolarBlock
extends AbstractGeneratorBlock<Tier, SolarConfig, SolarBlock>
implements IWaterLoggable {
    protected static final VoxelShape SHAPE = SolarBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final BooleanProperty OUTPUT = BooleanProperty.func_177716_a((String)"output");

    public SolarBlock(AbstractBlock.Properties properties, Tier variant) {
        super(properties, (Enum)variant);
        this.setStateProps(state -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)OUTPUT, (Comparable)Boolean.valueOf(false)));
    }

    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable ItemGroup group) {
        return super.getBlockItem(properties.func_200917_a(1), group);
    }

    public SolarConfig getConfig() {
        return Configs.SOLAR_PANEL;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SolarTile((Tier)this.variant);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nullable
    public AbstractContainer getContainer(int id, PlayerInventory inventory, AbstractTileEntity te, BlockRayTraceResult result) {
        if (te instanceof SolarTile) {
            return new SolarContainer(id, inventory, (SolarTile)te);
        }
        return null;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return this.createState(world, currentPos);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.createState((IWorld)context.func_195991_k(), context.func_195995_a());
    }

    private BlockState createState(IWorld world, BlockPos pos) {
        BlockState state = this.func_176223_P();
        boolean north = this.canAttach(state, world, pos, Direction.NORTH);
        boolean south = this.canAttach(state, world, pos, Direction.SOUTH);
        boolean west = this.canAttach(state, world, pos, Direction.WEST);
        boolean east = this.canAttach(state, world, pos, Direction.EAST);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(!north))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(!south))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(!west))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(!east))).func_206870_a((Property)OUTPUT, (Comparable)Boolean.valueOf(Energy.isPresent((TileEntity)world.func_175625_s(pos.func_177977_b()), (Direction)Direction.DOWN)))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
    }

    public boolean canAttach(BlockState state, IWorld world, BlockPos pos, Direction direction) {
        return world.func_180495_p(pos.func_177972_a(direction)).func_177230_c() == this;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, OUTPUT});
        super.func_206840_a(builder);
    }

    public List<Direction> getConnectedSides(BlockState state) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        if (!((Boolean)state.func_177229_b((Property)NORTH)).booleanValue()) {
            list.add(Direction.NORTH);
        }
        if (!((Boolean)state.func_177229_b((Property)SOUTH)).booleanValue()) {
            list.add(Direction.SOUTH);
        }
        if (!((Boolean)state.func_177229_b((Property)WEST)).booleanValue()) {
            list.add(Direction.WEST);
        }
        if (!((Boolean)state.func_177229_b((Property)EAST)).booleanValue()) {
            list.add(Direction.EAST);
        }
        return list;
    }
}

