/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.container;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import owmii.lib.client.screen.container.AbstractEnergyScreen;
import owmii.lib.client.util.Draw;
import owmii.lib.client.util.Text;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.logistics.fluid.Tank;
import owmii.lib.logistics.inventory.AbstractEnergyContainer;
import owmii.lib.util.Util;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.thermo.ThermoTile;
import owmii.powah.client.screen.Textures;
import owmii.powah.inventory.ThermoContainer;

public class ThermoScreen
extends AbstractEnergyScreen<ThermoTile, ThermoContainer> {
    public ThermoScreen(ThermoContainer container, PlayerInventory inv, ITextComponent title) {
        super((AbstractEnergyContainer)container, inv, title, Textures.THERMO);
    }

    protected void drawBackground(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluidStack;
        FluidAttributes fa;
        ResourceLocation still;
        super.drawBackground(matrix, partialTicks, mouseX, mouseY);
        Textures.THERMO_GAUGE.drawScalableH(matrix, ((ThermoTile)this.te).getEnergy().subSized(), this.field_147003_i + 5, this.field_147009_r + 5);
        Tank tank = ((ThermoTile)this.te).getTank();
        if (!tank.isEmpty() && (still = (fa = (fluidStack = tank.getFluid()).getFluid().getAttributes()).getStillTexture(fluidStack)) != null) {
            int color = fa.getColor(fluidStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            RenderSystem.color3f((float)red, (float)green, (float)blue);
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.mc.func_228015_a_(PlayerContainer.field_226615_c_).apply(still);
            this.bindTexture(PlayerContainer.field_226615_c_);
            Draw.gaugeV((TextureAtlasSprite)sprite, (int)(this.field_147003_i + 157), (int)(this.field_147009_r + 5), (int)14, (int)65, (int)tank.getCapacity(), (int)tank.getFluidAmount());
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        long percent = ((ThermoTile)this.te).getGeneration() > 0L ? 100L * ((ThermoTile)this.te).generating / ((ThermoTile)this.te).getGeneration() : 0L;
        this.field_230712_o_.func_238421_b_(matrix, percent + "% (" + ((ThermoTile)this.te).generating + " EF/t)", (float)(this.field_147003_i + 34), (float)(this.field_147009_r + 10), 0x555555);
    }

    protected void func_230459_a_(MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230459_a_(matrix, mouseX, mouseY);
        if (Textures.FURNATOR_GAUGE.isMouseOver(this.field_147003_i + 5, this.field_147009_r + 5, (double)mouseX, (double)mouseY)) {
            ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
            Energy energy = ((ThermoTile)this.te).getEnergy();
            list.add(new TranslationTextComponent("info.lollipop.stored").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.fe.stored", new Object[]{Util.addCommas((long)energy.getStored()), Util.numFormat((long)energy.getCapacity())}).func_240699_a_(TextFormatting.DARK_GRAY)));
            list.add(new TranslationTextComponent("info.lollipop.generates").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new StringTextComponent(Util.numFormat((long)((ThermoTile)this.te).getGeneration())).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick")).func_240699_a_(TextFormatting.DARK_GRAY)));
            list.add(new TranslationTextComponent("info.lollipop.max.extract").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new StringTextComponent(Util.numFormat((long)energy.getMaxExtract())).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick")).func_240699_a_(TextFormatting.DARK_GRAY)));
            this.func_243308_b(matrix, list, mouseX, mouseY);
        }
        Tank tank = ((ThermoTile)this.te).getTank();
        if (this.isMouseOver(mouseX - 157, mouseY - 5, 14, 65)) {
            ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
            if (!tank.isEmpty()) {
                list.add(new TranslationTextComponent("info.lollipop.coolant").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)tank.getFluid().getDisplayName().func_230531_f_().func_240699_a_(TextFormatting.AQUA)));
                list.add(new TranslationTextComponent("info.lollipop.stored").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.mb.stored", new Object[]{Util.addCommas((long)tank.getFluidAmount()), Util.numFormat((long)tank.getCapacity())}).func_240699_a_(TextFormatting.DARK_GRAY)));
                list.add(new TranslationTextComponent("info.lollipop.temperature").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.temperature.c", new Object[]{"" + TextFormatting.AQUA + PowahAPI.getCoolant(tank.getFluid().getFluid())}).func_240699_a_(TextFormatting.DARK_GRAY)));
            } else {
                list.add(new TranslationTextComponent("info.lollipop.fluid").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new StringTextComponent("---").func_240699_a_(TextFormatting.DARK_GRAY)));
            }
            this.func_243308_b(matrix, list, mouseX, mouseY);
        }
    }
}

