/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter;

import com.alcatrazescapee.primalwinter.Config;
import com.alcatrazescapee.primalwinter.mixin.world.biome.BiomeAmbienceAccessor;
import com.alcatrazescapee.primalwinter.util.WeatherData;
import com.alcatrazescapee.primalwinter.world.ModConfiguredFeatures;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class EventHandler {
    public static void init() {
        IEventBus forge = MinecraftForge.EVENT_BUS;
        IEventBus mod = FMLJavaModLoadingContext.get().getModEventBus();
        mod.addListener(EventHandler::setup);
        forge.addGenericListener(World.class, EventHandler::attachWorldCapabilities);
        forge.addListener(EventHandler::onRegisterCommands);
        forge.addListener(EventHandler::onWorldLoad);
        forge.addListener(EventHandler::onBiomeLoading);
    }

    public static void setup(FMLCommonSetupEvent event) {
        ModConfiguredFeatures.setup();
        WeatherData.setup();
    }

    public static void attachWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        event.addCapability(WeatherData.ID, (ICapabilityProvider)new WeatherData());
    }

    public static void onRegisterCommands(RegisterCommandsEvent event) {
        if (((Boolean)Config.COMMON.disableWeatherCommand.get()).booleanValue()) {
            event.getDispatcher().getRoot().getChildren().removeIf(node -> node.getName().equals("weather"));
            event.getDispatcher().register((LiteralArgumentBuilder)Commands.func_197057_a((String)"weather").executes(source -> {
                ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Not even a command can overcome this storm... (This command is disabled by Primal Winter)"), false);
                return 0;
            }));
        }
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld && !((ServerWorld)event.getWorld()).func_234925_Z_()) {
            WeatherData.trySetEndlessStorm((ServerWorld)event.getWorld());
        }
    }

    public static void onBiomeLoading(BiomeLoadingEvent event) {
        if (Config.COMMON.isWinterBiome(event.getName())) {
            event.setClimate(new Biome.Climate(Biome.RainType.SNOW, -0.5f, Biome.TemperatureModifier.NONE, event.getClimate().field_242463_e));
            BiomeAmbienceAccessor effectsAccess = (BiomeAmbienceAccessor)event.getEffects();
            effectsAccess.accessor$setWaterColor(3750089);
            effectsAccess.accessor$setFogWaterColor(329011);
            MobSpawnInfoBuilder spawnSettingsBuilder = event.getSpawns();
            spawnSettingsBuilder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200750_ap, 320, 4, 4));
            spawnSettingsBuilder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200786_Z, 4, 1, 2));
            spawnSettingsBuilder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200745_ak, 4, 4, 8));
            BiomeGenerationSettingsBuilder generationSettingsBuilder = event.getGeneration();
            generationSettingsBuilder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ModConfiguredFeatures.ICE_SPIKES);
            generationSettingsBuilder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ModConfiguredFeatures.ICE_PATCH);
            generationSettingsBuilder.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.FREEZE_TOP_LAYER);
            generationSettingsBuilder.func_242516_a(StructureFeatures.field_244141_g);
            generationSettingsBuilder.getFeatures(GenerationStage.Decoration.TOP_LAYER_MODIFICATION).removeIf(feature -> feature.get() == Features.field_243794_T);
        }
    }
}

