/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.client;

import com.alcatrazescapee.primalwinter.Config;
import com.alcatrazescapee.primalwinter.client.ModParticleTypes;
import com.alcatrazescapee.primalwinter.client.SnowParticle;
import com.alcatrazescapee.primalwinter.common.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class ClientEventHandler {
    private static final int NOPE = 0xFFFFFF;

    public static void init() {
        IEventBus forge = MinecraftForge.EVENT_BUS;
        IEventBus mod = FMLJavaModLoadingContext.get().getModEventBus();
        mod.addListener(ClientEventHandler::onClientSetup);
        mod.addListener(ClientEventHandler::onRegisterBlockColors);
        mod.addListener(ClientEventHandler::onRegisterItemColors);
        mod.addListener(ClientEventHandler::onRegisterParticleFactories);
        forge.addListener(ClientEventHandler::onRenderFogDensity);
        forge.addListener(ClientEventHandler::onRenderFogColors);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.SNOWY_VINE.get()), (RenderType)RenderType.func_228643_e_());
    }

    public static void onRegisterBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        colors.func_186722_a((state, world, pos, tintIndex) -> tintIndex == 0 ? FoliageColors.func_77466_a() : 0xFFFFFF, new Block[]{(Block)ModBlocks.SNOWY_SPRUCE_LEAVES.get()});
        colors.func_186722_a((state, world, pos, tintIndex) -> tintIndex == 0 ? FoliageColors.func_77469_b() : 0xFFFFFF, new Block[]{(Block)ModBlocks.SNOWY_BIRCH_LEAVES.get()});
        colors.func_186722_a((state, world, pos, tintIndex) -> {
            if (tintIndex == 0) {
                return world != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)world, (BlockPos)pos) : FoliageColors.func_77468_c();
            }
            return 0xFFFFFF;
        }, new Block[]{(Block)ModBlocks.SNOWY_OAK_LEAVES.get(), (Block)ModBlocks.SNOWY_DARK_OAK_LEAVES.get(), (Block)ModBlocks.SNOWY_JUNGLE_LEAVES.get(), (Block)ModBlocks.SNOWY_ACACIA_LEAVES.get(), (Block)ModBlocks.SNOWY_VINE.get()});
    }

    public static void onRegisterItemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        colors.func_199877_a((stack, tintIndex) -> {
            if (tintIndex == 0) {
                BlockState state = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
                return event.getBlockColors().func_228054_a_(state, null, null, tintIndex);
            }
            return 0xFFFFFF;
        }, new IItemProvider[]{(IItemProvider)ModBlocks.SNOWY_VINE.get(), (IItemProvider)ModBlocks.SNOWY_OAK_LEAVES.get(), (IItemProvider)ModBlocks.SNOWY_SPRUCE_LEAVES.get(), (IItemProvider)ModBlocks.SNOWY_BIRCH_LEAVES.get(), (IItemProvider)ModBlocks.SNOWY_JUNGLE_LEAVES.get(), (IItemProvider)ModBlocks.SNOWY_ACACIA_LEAVES.get(), (IItemProvider)ModBlocks.SNOWY_DARK_OAK_LEAVES.get()});
    }

    public static void onRegisterParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModParticleTypes.SNOW.get(), SnowParticle.Factory::new);
    }

    public static void onRenderFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (event.getInfo().func_216773_g() instanceof PlayerEntity) {
            int light;
            PlayerEntity player = (PlayerEntity)event.getInfo().func_216773_g();
            World world = player.field_70170_p;
            Biome biome = world.func_226691_t_(player.func_233580_cy_());
            if ((double)world.func_72867_j(1.0f) > 0.2 && biome.func_201851_b() == Biome.RainType.SNOW && biome.func_225486_c(player.func_233580_cy_()) < 0.15f && (light = world.func_226658_a_(LightType.SKY, new BlockPos(player.func_174824_e((float)event.getRenderPartialTicks())))) > 3 && event.getInfo().func_216771_k().func_206886_c() == Fluids.field_204541_a) {
                event.setCanceled(true);
                event.setDensity((float)(light - 3) * ((Double)Config.CLIENT.fogDensity.get()).floatValue() / 13.0f);
            }
        }
    }

    public static void onRenderFogColors(EntityViewRenderEvent.FogColors event) {
        if (event.getInfo().func_216773_g() instanceof PlayerEntity) {
            int light;
            PlayerEntity player = (PlayerEntity)event.getInfo().func_216773_g();
            World world = player.field_70170_p;
            Biome biome = world.func_226691_t_(player.func_233580_cy_());
            if ((double)world.func_72867_j(1.0f) > 0.2 && biome.func_201851_b() == Biome.RainType.SNOW && biome.func_225486_c(player.func_233580_cy_()) < 0.15f && (light = player.field_70170_p.func_226658_a_(LightType.SKY, new BlockPos(player.func_174824_e((float)event.getRenderPartialTicks())))) > 3 && event.getInfo().func_216771_k().func_206886_c() == Fluids.field_204541_a) {
                float partialTicks = (float)event.getRenderPartialTicks();
                float angle = player.field_70170_p.func_72929_e(partialTicks);
                float height = MathHelper.func_76134_b((float)angle);
                float delta = MathHelper.func_76131_a((float)((height + 0.4f) / 0.8f), (float)0.0f, (float)1.0f);
                int colorDay = (Integer)Config.CLIENT.fogColorDay.get();
                int colorNight = (Integer)Config.CLIENT.fogColorNight.get();
                float red = (float)(colorDay >> 16 & 0xFF) * delta + (float)(colorNight >> 16 & 0xFF) * (1.0f - delta);
                float green = (float)(colorDay >> 8 & 0xFF) * delta + (float)(colorNight >> 8 & 0xFF) * (1.0f - delta);
                float blue = (float)(colorDay & 0xFF) * delta + (float)(colorNight & 0xFF) * (1.0f - delta);
                event.setRed(red / 255.0f);
                event.setGreen(green / 255.0f);
                event.setBlue(blue / 255.0f);
            }
        }
    }
}

