/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.mixin.client.renderer;

import com.alcatrazescapee.primalwinter.Config;
import com.alcatrazescapee.primalwinter.client.ModParticleTypes;
import com.alcatrazescapee.primalwinter.client.ModSoundEvents;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
public abstract class WorldRendererMixin {
    private static final ResourceLocation RAIN_TEXTURES = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation SNOW_TEXTURES = new ResourceLocation("textures/environment/snow.png");
    @Shadow
    @Final
    private Minecraft field_72777_q;
    @Shadow
    @Final
    private float[] field_228411_ak_;
    @Shadow
    @Final
    private float[] field_228412_al_;
    @Shadow
    private ClientWorld field_72769_h;
    @Shadow
    private int field_72773_u;
    private int windSoundTime = 0;
    private int rainSoundTime = 0;

    @Inject(method={"renderSnowAndRain"}, at={@At(value="HEAD")}, cancellable=true)
    public void inject$renderWeather(LightTexture manager, float partialTicks, double xIn, double yIn, double zIn, CallbackInfo ci) {
        if (((Boolean)Config.CLIENT.weatherRenderChanges.get()).booleanValue()) {
            float rainStrength;
            if (this.field_72777_q != null && this.field_72777_q.field_71460_t != null && (rainStrength = this.field_72769_h.func_72867_j(partialTicks)) > 0.0f) {
                this.field_72777_q.field_71460_t.func_228384_l_().func_205109_c();
                Vector3d vec3d = this.field_72777_q.field_71460_t.func_215316_n().func_216785_c();
                int xPos = MathHelper.func_76128_c((double)vec3d.func_82615_a());
                int yPos = MathHelper.func_76128_c((double)vec3d.func_82617_b());
                int zPos = MathHelper.func_76128_c((double)vec3d.func_82616_c());
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                RenderSystem.enableAlphaTest();
                RenderSystem.disableCull();
                RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.defaultAlphaFunc();
                RenderSystem.enableDepthTest();
                int weatherAmount = (Integer)Config.CLIENT.snowDensity.get();
                RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
                int flag = -1;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                BlockPos.Mutable mutablePos = new BlockPos.Mutable();
                for (int z = zPos - weatherAmount; z <= zPos + weatherAmount; ++z) {
                    for (int x = xPos - weatherAmount; x <= xPos + weatherAmount; ++x) {
                        int l1 = (z - zPos + 16) * 32 + x - xPos + 16;
                        double d0 = (double)this.field_228411_ak_[l1] * 0.5;
                        double d1 = (double)this.field_228412_al_[l1] * 0.5;
                        mutablePos.func_181079_c(x, 0, z);
                        Biome biome = this.field_72769_h.func_226691_t_((BlockPos)mutablePos);
                        if (biome.func_201851_b() == Biome.RainType.NONE) continue;
                        int i2 = this.field_72769_h.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)mutablePos).func_177956_o();
                        int y = yPos - weatherAmount;
                        int k2 = yPos + weatherAmount;
                        if (y < i2) {
                            y = i2;
                        }
                        if (k2 < i2) {
                            k2 = i2;
                        }
                        int l2 = i2;
                        if (i2 < yPos) {
                            l2 = yPos;
                        }
                        if (y == k2) continue;
                        Random random = new Random(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761);
                        mutablePos.func_181079_c(x, y, z);
                        float temperature = biome.func_225486_c((BlockPos)mutablePos);
                        if (flag != 0) {
                            flag = 0;
                            if ((double)temperature > 0.15) {
                                this.field_72777_q.func_110434_K().func_110577_a(RAIN_TEXTURES);
                            } else {
                                this.field_72777_q.func_110434_K().func_110577_a(SNOW_TEXTURES);
                            }
                            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        int i3 = this.field_72773_u + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F;
                        float f3 = -((float)i3 + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                        double d2 = (double)((float)x + 0.5f) - xIn;
                        double d4 = (double)((float)z + 0.5f) - zIn;
                        float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d4 * d4)) / (float)weatherAmount;
                        float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * rainStrength;
                        mutablePos.func_181079_c(x, l2, z);
                        int j3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)this.field_72769_h, (BlockPos)mutablePos);
                        bufferbuilder.func_225582_a_((double)x - xIn - d0 + 0.5, (double)k2 - yIn, (double)z - zIn - d1 + 0.5).func_225583_a_(0.0f, (float)y * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)x - xIn + d0 + 0.5, (double)k2 - yIn, (double)z - zIn + d1 + 0.5).func_225583_a_(1.0f, (float)y * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)x - xIn + d0 + 0.5, (double)y - yIn, (double)z - zIn + d1 + 0.5).func_225583_a_(1.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        bufferbuilder.func_225582_a_((double)x - xIn - d0 + 0.5, (double)y - yIn, (double)z - zIn - d1 + 0.5).func_225583_a_(0.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                    }
                }
                if (flag >= 0) {
                    tessellator.func_78381_a();
                }
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
                RenderSystem.defaultAlphaFunc();
                RenderSystem.disableAlphaTest();
                this.field_72777_q.field_71460_t.func_228384_l_().func_205108_b();
            }
            ci.cancel();
        }
    }

    @Inject(method={"tickRain"}, at={@At(value="RETURN")})
    public void inject$tickRain(ActiveRenderInfo renderInfo, CallbackInfo ci) {
        float f = this.field_72769_h.func_72867_j(1.0f) / (Minecraft.func_71375_t() ? 1.0f : 2.0f);
        if (f > 0.0f) {
            Random random = new Random((long)this.field_72773_u * 312987231L);
            ClientWorld worldView = this.field_72769_h;
            BlockPos blockPos = new BlockPos((Vector3i)renderInfo.func_216780_d());
            BlockPos blockPos2 = null;
            int i = (int)(100.0f * f * f) / (this.field_72777_q.field_71474_y.field_74362_aa == ParticleStatus.DECREASED ? 2 : 1);
            for (int j = 0; j < i; ++j) {
                int k = random.nextInt(21) - 10;
                int l = random.nextInt(21) - 10;
                BlockPos blockPos3 = worldView.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockPos.func_177982_a(k, 0, l)).func_177977_b();
                Biome biome = worldView.func_226691_t_(blockPos3);
                if (blockPos3.func_177956_o() <= 0 || blockPos3.func_177956_o() > blockPos.func_177956_o() + 10 || blockPos3.func_177956_o() < blockPos.func_177956_o() - 10 || biome.func_201851_b() != Biome.RainType.SNOW || !(biome.func_225486_c(blockPos3) < 0.15f)) continue;
                blockPos2 = blockPos3;
                if (this.field_72777_q.field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) break;
                double d = random.nextDouble();
                double e = random.nextDouble();
                BlockState blockState = worldView.func_180495_p(blockPos3);
                FluidState fluidState = worldView.func_204610_c(blockPos3);
                VoxelShape voxelShape = blockState.func_196952_d((IBlockReader)worldView, blockPos3);
                double g = voxelShape.func_197760_b(Direction.Axis.Y, d, e);
                double h = fluidState.func_215679_a((IBlockReader)worldView, blockPos3);
                double m = Math.max(g, h);
                BasicParticleType particleEffect = !fluidState.func_206884_a((ITag)FluidTags.field_206960_b) && !blockState.func_203425_a(Blocks.field_196814_hQ) && !CampfireBlock.func_226915_i_((BlockState)blockState) ? (IParticleData)ModParticleTypes.SNOW.get() : ParticleTypes.field_197601_L;
                this.field_72769_h.func_195594_a((IParticleData)particleEffect, (double)blockPos3.func_177958_n() + d, (double)blockPos3.func_177956_o() + m, (double)blockPos3.func_177952_p() + e, 0.0, 0.0, 0.0);
            }
            if (blockPos2 != null && random.nextInt(3) < this.rainSoundTime++ && ((Boolean)Config.CLIENT.snowSounds.get()).booleanValue()) {
                this.rainSoundTime = 0;
                if (blockPos2.func_177956_o() > blockPos.func_177956_o() + 1 && worldView.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockPos).func_177956_o() > MathHelper.func_76141_d((float)blockPos.func_177956_o())) {
                    this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.03f, 0.05f, false);
                } else {
                    this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.06f, 0.1f, false);
                }
            }
            if (this.windSoundTime-- < 0 && ((Boolean)Config.CLIENT.windSounds.get()).booleanValue()) {
                BlockPos playerPos = renderInfo.func_216780_d();
                Entity entity = renderInfo.func_216773_g();
                int light = renderInfo.func_216773_g().field_70170_p.func_226658_a_(LightType.SKY, playerPos);
                if (light > 3 && entity.field_70170_p.func_72896_J() && entity.field_70170_p.func_226691_t_(playerPos).func_225486_c(playerPos) < 0.15f) {
                    float volumeModifier = 0.2f + (float)(light - 3) * 0.01f;
                    float pitchModifier = 0.7f;
                    if (renderInfo.func_216771_k().func_206886_c() != Fluids.field_204541_a) {
                        pitchModifier = 0.3f;
                    }
                    this.windSoundTime = 60 + random.nextInt(30);
                    this.field_72769_h.func_184156_a(playerPos, (SoundEvent)ModSoundEvents.WIND.get(), SoundCategory.WEATHER, volumeModifier, pitchModifier, true);
                } else {
                    this.windSoundTime += 5;
                }
            }
        }
    }

    @Redirect(method={"renderSky(Lcom/mojang/blaze3d/matrix/MatrixStack;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/world/DimensionRenderInfo;getSunriseColor(FF)[F"))
    private float[] redirect$getSunriseColor$getSunriseColor(DimensionRenderInfo renderInfo, float skyAngle, float tickDelta, MatrixStack matrixStackIn, float partialTicks) {
        BlockPos pos = this.field_72777_q.field_71460_t.func_215316_n().func_216780_d();
        Biome biome = this.field_72769_h.func_226691_t_(pos);
        if (biome.func_225486_c(pos) < 0.15f && renderInfo instanceof DimensionRenderInfo.Overworld) {
            return null;
        }
        return renderInfo.func_230492_a_(skyAngle, tickDelta);
    }
}

