/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.util;

import com.alcatrazescapee.primalwinter.Config;
import com.alcatrazescapee.primalwinter.common.ModBlocks;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public final class Helpers {
    public static void placeExtraSnowOnTickChunk(ServerWorld world, Chunk chunk) {
        if (((Boolean)Config.COMMON.enableSnowAccumulationDuringWeather.get()).booleanValue() && world.field_73012_v.nextInt(16) == 0) {
            int blockX = chunk.func_76632_l().func_180334_c();
            int blockZ = chunk.func_76632_l().func_180333_d();
            BlockPos pos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, world.func_217383_a(blockX, 0, blockZ, 15));
            BlockState state = world.func_180495_p(pos);
            Biome biome = world.func_226691_t_(pos);
            if (world.func_72896_J() && (double)biome.func_225486_c(pos) < 0.15 && world.func_226658_a_(LightType.BLOCK, pos) < 10 && state.func_177230_c() == Blocks.field_150433_aE) {
                BlockPos belowPos;
                BlockState belowState;
                Block replacementBlock;
                int layers = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208129_ad);
                if (layers < 5) {
                    world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf(1 + layers)));
                }
                if ((replacementBlock = ModBlocks.SNOWY_TERRAIN_BLOCKS.getOrDefault((belowState = world.func_180495_p(belowPos = pos.func_177977_b())).func_177230_c(), () -> null).get()) != null) {
                    world.func_175656_a(belowPos, replacementBlock.func_176223_P());
                }
            }
        }
    }

    public static BlockPos adjustPosForIceFeature(ISeedReader worldIn, BlockPos pos) {
        while (worldIn.func_175623_d(pos) && pos.func_177956_o() > 2) {
            pos = pos.func_177977_b();
        }
        BlockState originalState = worldIn.func_180495_p(pos);
        if (!BlockTags.field_206952_E.func_230235_a_((Object)originalState.func_177230_c()) && !BlockTags.field_200031_h.func_230235_a_((Object)originalState.func_177230_c())) {
            worldIn.func_180501_a(pos, Blocks.field_196604_cC.func_176223_P(), 2);
        }
        return pos;
    }

    public static BlockState copyProperties(BlockState oldState, BlockState newState) {
        for (Property property : oldState.func_235904_r_()) {
            if (!newState.func_235904_r_().contains(property)) continue;
            newState = Helpers.copyProperty(property, oldState, newState);
        }
        return newState;
    }

    public static <T extends Comparable<T>> BlockState copyProperty(Property<T> property, BlockState original, BlockState replacement) {
        return (BlockState)replacement.func_206870_a(property, original.func_177229_b(property));
    }

    @Nonnull
    public static <T> T notNull() {
        return null;
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }
}

