/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.primalwinter.util;

import com.alcatrazescapee.primalwinter.Config;
import com.alcatrazescapee.primalwinter.util.Helpers;
import com.alcatrazescapee.primalwinter.util.NoopStorage;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class WeatherData
implements ICapabilitySerializable<ByteNBT> {
    @CapabilityInject(value=WeatherData.class)
    public static final Capability<WeatherData> CAPABILITY = (Capability)Helpers.notNull();
    public static final ResourceLocation ID = new ResourceLocation("primalwinter", "weather_data");
    private final LazyOptional<WeatherData> capability = LazyOptional.of(() -> this);
    private boolean alreadySetWorldToWinter = false;

    public static void setup() {
        CapabilityManager.INSTANCE.register(WeatherData.class, new NoopStorage(), () -> {
            throw new UnsupportedOperationException();
        });
    }

    public static void trySetEndlessStorm(ServerWorld world) {
        WeatherData cap = (WeatherData)world.getCapability(CAPABILITY).orElseThrow(() -> new IllegalStateException("Expected WeatherData to exist on World " + world.func_234923_W_() + " / " + world.func_230315_m_()));
        if (!cap.alreadySetWorldToWinter) {
            cap.alreadySetWorldToWinter = true;
            if (Config.COMMON.isWinterDimension(world.func_234923_W_().func_240901_a_())) {
                ((GameRules.BooleanValue)world.func_82736_K().func_223585_a(GameRules.field_223617_t)).func_223570_a(false, world.func_73046_m());
                world.func_241113_a_(0, Integer.MAX_VALUE, true, true);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return cap == CAPABILITY ? this.capability.cast() : LazyOptional.empty();
    }

    public ByteNBT serializeNBT() {
        return ByteNBT.func_229672_a_((boolean)this.alreadySetWorldToWinter);
    }

    public void deserializeNBT(ByteNBT nbt) {
        this.alreadySetWorldToWinter = nbt.func_150290_f() == 1;
    }
}

